/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import fr.ifremer.coser.CoserBusinessConfig;
import java.awt.Font;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;

public class CoserConfig
extends CoserBusinessConfig {
    private static final Log log = LogFactory.getLog(CoserConfig.class);

    public CoserConfig() {
        this.loadDefaultOptions(CoserOption.values());
    }

    public String getLookAndFeel() {
        String className = this.getOption(CoserOption.LOOKANDFEEL.key);
        return className;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.setOption(CoserOption.LOOKANDFEEL.key, lookAndFeel);
    }

    public String getApplicationVersion() {
        String result = this.getOption(CoserOption.APPLICATION_VERSION.key);
        return result;
    }

    public void setSupportEmail(String supportEmail) {
        this.setOption(CoserOption.SUPPORT_EMAIL.key, supportEmail);
    }

    public String getSupportEmail() {
        String result = this.getOption(CoserOption.SUPPORT_EMAIL.key);
        return result;
    }

    public String getWebsiteURL() {
        String result = this.getOption(CoserOption.WEBSITE_URL.key);
        return result;
    }

    public int getSwingFontSize() {
        int result = this.getOptionAsInt(CoserOption.SWING_FONT_SIZE.key);
        return result;
    }

    public void setSwingFontSize(int swingFontSize) {
        int old = this.getSwingFontSize();
        if (old != swingFontSize) {
            this.setOption(CoserOption.SWING_FONT_SIZE.key, String.valueOf(swingFontSize));
            this.updateSwingFont(swingFontSize);
        }
    }

    public void updateSwingFont() {
        this.updateSwingFont(this.getSwingFontSize());
    }

    protected void updateSwingFont(int newIncrease) {
        for (Object key : UIManager.getDefaults().keySet()) {
            if (!key.toString().endsWith("Font") && !key.toString().endsWith(".font")) continue;
            Font font = UIManager.getFont(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update " + key + " to size " + newIncrease));
            }
            font = font.deriveFont((float)newIncrease);
            UIManager.put(key, new FontUIResource(font));
        }
    }

    static {
        I18n.n((String)"numbereditor.cleanAll", (Object[])new Object[0]);
        I18n.n((String)"numbereditor.cleanOne", (Object[])new Object[0]);
        I18n.n((String)"numbereditor.dot", (Object[])new Object[0]);
        I18n.n((String)"numbereditor.sign", (Object[])new Object[0]);
    }

    public static enum CoserOption implements ConfigOptionDef
    {
        CONFIG_FILE("config.file", I18n.n((String)"coser.config.config.file.description", (Object[])new Object[0]), "coser.properties", String.class, true, true),
        LOOKANDFEEL("coser.lookandfeel", I18n.n((String)"coser.config.lookandfeel.description", (Object[])new Object[0]), null, String.class, false, false),
        APPLICATION_VERSION("coser.application.version", I18n.n((String)"coser.config.application.version.description", (Object[])new Object[0]), null, String.class, false, false),
        SUPPORT_EMAIL("coser.support.email", I18n.n((String)"coser.config.support.email.description", (Object[])new Object[0]), "support@codelutin.com", String.class, false, false),
        WEBSITE_URL("coser.website", I18n.n((String)"coser.config.website.description", (Object[])new Object[0]), "https://coser.codelutin.com", String.class, false, false),
        SWING_FONT_SIZE("coser.swingfontsize", I18n.n((String)"coser.config.swingfontsize.description", (Object[])new Object[0]), "12", Integer.class, false, false);

        private final String key;
        private final String description;
        private final String defaultValue;
        private final Class<?> type;
        private final boolean isTransient;
        private final boolean isFinal;

        private CoserOption(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isTransient = isTransient;
            this.isFinal = isFinal;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setDefaultValue(String defaultValue) {
        }

        public void setTransient(boolean isTransient) {
        }

        public void setFinal(boolean isFinal) {
        }
    }
}

