/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.control;

import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.control.ControlError;
import fr.ifremer.coser.control.ControlErrorGroup;
import fr.ifremer.coser.ui.control.GlobalControlErrorModel;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.nuiton.i18n.I18n;

public class ControlErrorTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -6423364126451874968L;
    protected ImageIcon fatalIcon = SwingValidatorUtil.getFatalIcon();
    protected ImageIcon errorIcon = SwingValidatorUtil.getErrorIcon();
    protected ImageIcon warningIcon = SwingValidatorUtil.getWarningIcon();
    protected ImageIcon infoIcon = SwingValidatorUtil.getInfoIcon();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        GlobalControlErrorModel model = (GlobalControlErrorModel)((Object)tree.getModel());
        JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Object userObject = ((TreeTableNode)value).getUserObject();
        ImageIcon icon = null;
        String text = null;
        String tooltipText = null;
        if (userObject instanceof String) {
            text = I18n._((String)((String)userObject), (Object[])new Object[0]) + " (" + model.getChildCount(value) + ")";
        } else if (userObject instanceof CoserConstants.Category) {
            text = I18n._((String)((CoserConstants.Category)userObject).getTranslationKey(), (Object[])new Object[0]) + " (" + model.getChildCount(value) + ")";
        } else if (userObject instanceof ControlErrorGroup) {
            ControlErrorGroup validationErrorGroup = (ControlErrorGroup)userObject;
            CoserConstants.ValidationLevel level = validationErrorGroup.getValidationLevel();
            switch (level) {
                case FATAL: {
                    icon = this.fatalIcon;
                    break;
                }
                case ERROR: {
                    icon = this.errorIcon;
                    break;
                }
                case WARNING: {
                    icon = this.warningIcon;
                    break;
                }
                case INFO: {
                    icon = this.infoIcon;
                }
            }
            String message = validationErrorGroup.getMessage();
            text = I18n._((String)message, (Object[])new Object[0]) + " (" + model.getChildCount(value) + ")";
        } else if (userObject instanceof ControlError) {
            ControlError validationError = (ControlError)userObject;
            CoserConstants.ValidationLevel level = validationError.getLevel();
            switch (level) {
                case FATAL: {
                    icon = this.fatalIcon;
                    break;
                }
                case ERROR: {
                    icon = this.errorIcon;
                    break;
                }
                case WARNING: {
                    icon = this.warningIcon;
                    break;
                }
                case INFO: {
                    icon = this.infoIcon;
                }
            }
            String message = validationError.getDetailMessage();
            if (message == null) {
                message = validationError.getMessage();
            }
            text = I18n._((String)message, (Object[])new Object[0]);
            tooltipText = validationError.getTipMessage();
        }
        component.setText(text);
        component.setIcon(icon);
        component.setToolTipText(tooltipText);
        return component;
    }
}

