/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.util;

import fr.ifremer.coser.CoserConfig;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.nuiton.i18n.I18n;

public class ErrorHelper
implements ErrorReporter {
    private static final Log log = LogFactory.getLog(ErrorHelper.class);
    protected CoserConfig coserConfig;

    public ErrorHelper(CoserConfig coserConfig) {
        this.coserConfig = coserConfig;
    }

    public void showErrorDialog(Component parent, String message, Throwable cause) {
        JXErrorPane pane = new JXErrorPane();
        ErrorInfo info = new ErrorInfo(I18n._((String)"coser.ui.error.title", (Object[])new Object[0]), I18n._((String)"coser.ui.error.htmlmessage", (Object[])new Object[]{message}), null, null, cause, null, null);
        pane.setErrorInfo(info);
        pane.setErrorReporter((ErrorReporter)this);
        JXErrorPane.showDialog((Component)parent, (JXErrorPane)pane);
    }

    public void showErrorDialog(String message) {
        this.showErrorDialog(message, null);
    }

    public void showErrorDialog(String message, Throwable cause) {
        this.showErrorDialog(null, message, cause);
    }

    public void reportError(ErrorInfo errorInfo) {
        block3: {
            try {
                String emailTo = this.coserConfig.getSupportEmail();
                MultiPartEmail email = new MultiPartEmail();
                email.setHostName(this.coserConfig.getSmtpHost());
                email.addTo(emailTo, "Support");
                email.setFrom("no-reply@forge.codelutin.com", "Coser");
                email.setSubject("Project error notification : Coser");
                email.addReplyTo("no-reply@forge.codelutin.com");
                StringBuffer message = new StringBuffer();
                message.append(this.formatMessage("Project", "Coser " + this.coserConfig.getApplicationVersion()));
                message.append(this.formatMessage("Date", new Date().toString()));
                message.append(this.formatMessage("Title", errorInfo.getTitle()));
                message.append(this.formatMessage("Description", errorInfo.getBasicErrorMessage().replaceAll("<[^>]+>", "")));
                message.append(this.formatMessage("Configuration", null));
                ArrayList<String> propertiesNames = new ArrayList<String>(this.coserConfig.getOptions().stringPropertyNames());
                Collections.sort(propertiesNames);
                for (String propertyName : propertiesNames) {
                    if (propertyName.contains("pass")) continue;
                    message.append("\t" + propertyName + " : " + this.coserConfig.getOptions().getProperty(propertyName) + "\n");
                }
                StringWriter out = new StringWriter();
                PrintWriter writer = new PrintWriter(out);
                errorInfo.getErrorException().printStackTrace(writer);
                message.append(this.formatMessage("Exception", out.toString()));
                email.setContent((Object)message.toString(), "text/plain; charset=ISO-8859-9");
                email.send();
                JOptionPane.showMessageDialog(null, I18n._((String)"coser.ui.error.reportSendTo", (Object[])new Object[]{emailTo}));
            }
            catch (EmailException ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't send report email", (Throwable)ex);
            }
        }
    }

    protected String formatMessage(String category, String content) {
        String formatted = category + " :\n";
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            formatted = formatted + "\t" + content + "\n";
        }
        return formatted;
    }
}

