/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui;

import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.ui.CoserFrame;
import fr.ifremer.coser.ui.HomeView;
import fr.ifremer.coser.ui.common.CommonHandler;
import fr.ifremer.coser.ui.control.ControlHandler;
import fr.ifremer.coser.ui.control.ControlView;
import fr.ifremer.coser.ui.option.NoCopiedLayerUI;
import fr.ifremer.coser.ui.option.OptionHandler;
import fr.ifremer.coser.ui.option.ValidatorDialog;
import fr.ifremer.coser.ui.project.ProjectCreationView;
import fr.ifremer.coser.ui.project.ProjectEditView;
import fr.ifremer.coser.ui.project.ProjectHandler;
import fr.ifremer.coser.ui.project.ProjectOpenView;
import fr.ifremer.coser.ui.project.ProjectSummaryView;
import fr.ifremer.coser.ui.result.ResultHandler;
import fr.ifremer.coser.ui.result.SelectUploadResultView;
import fr.ifremer.coser.ui.selection.SelectionHandler;
import fr.ifremer.coser.ui.selection.SelectionView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.Resource;
import org.nuiton.widget.AboutFrame;
import org.nuiton.widget.SwingSession;

public class CoserFrameHandler
extends CommonHandler {
    private static final Log log = LogFactory.getLog(CoserFrameHandler.class);
    protected CoserFrame view;

    public CoserFrameHandler(CoserFrame view) {
        this.view = view;
    }

    public void switchLanguage(CoserFrame frame, Locale newLocale) {
        CoserConfig config = frame.getContextValue(CoserConfig.class);
        config.setLocale(newLocale);
        config.saveForUser(new String[0]);
        JOptionPane.showMessageDialog(frame, I18n._((String)"coser.ui.locale.mustRestart", (Object[])new Object[0]), I18n._((String)"coser.ui.locale.title", (Object[])new Object[0]), 1);
    }

    public void showHomeView() {
        HomeView homeView = new HomeView();
        homeView.setHandler(this);
        this.setMainComponent(homeView);
    }

    public void showProjectCreationView() {
        ProjectCreationView projectCreationView = new ProjectCreationView((JAXXContext)this.view);
        projectCreationView.setHandler(new ProjectHandler());
        this.setMainComponent((Component)((Object)projectCreationView));
    }

    public void showProjectOpenView() {
        ProjectOpenView projectOpenView = new ProjectOpenView((JAXXContext)this.view);
        projectOpenView.setHandler(new ProjectHandler());
        this.setMainComponent((Component)((Object)projectOpenView));
    }

    public void showProjectEditView() {
        Project project = this.view.getProject();
        ProjectEditView projectEditView = new ProjectEditView((JAXXContext)this.view);
        projectEditView.setHandler(new ProjectHandler());
        projectEditView.setProject(project);
        this.setMainComponent((Component)((Object)projectEditView));
    }

    protected void setMainComponent(Component component) {
        this.view.getMainViewContent().removeAll();
        if (component != null) {
            this.view.getMainViewContent().add(component, "Center");
        }
        this.view.getMainViewContent().repaint();
        this.view.getMainViewContent().validate();
    }

    public void quit() {
        SwingSession session = this.view.getContextValue(SwingSession.class);
        session.save();
        System.exit(0);
    }

    public void showCoserConfiguration() {
        CoserConfig config = this.view.getContextValue(CoserConfig.class);
        ConfigUIHelper modelBuilder = new ConfigUIHelper((ApplicationConfig)config);
        modelBuilder.addCategory(I18n._((String)"coser.config.category.path", (Object[])new Object[0]), I18n._((String)"coser.config.category.path.description", (Object[])new Object[0]));
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.PROJECTS_DIRECTORY);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.VALIDATOR_DIRECTORY);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.REFERENCE_SPECIES);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.REFERENCE_TYPE_ESPECES);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.WEB_FRONT_END);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.WEB_ZONES);
        modelBuilder.addCategory(I18n._((String)"coser.config.category.configuration", (Object[])new Object[0]), I18n._((String)"coser.config.category.configuration.description", (Object[])new Object[0]));
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.CONTROL_NOBSMIN);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.CONTROL_DIFF_CATCH_LENGTH);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.CONTROL_TYPE_FISH);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.SELECTION_FILTER_OCCURRENCE);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.SELECTION_FILTER_DENSITY);
        modelBuilder.addCategory(I18n._((String)"coser.config.category.misc", (Object[])new Object[0]), I18n._((String)"coser.config.category.misc.description", (Object[])new Object[0]));
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserBusinessConfig.CoserBusinessOption.SMTP_HOST);
        modelBuilder.addOption((ApplicationConfig.OptionDef)CoserConfig.CoserOption.SUPPORT_EMAIL);
        ConfigUI configUI = modelBuilder.buildUI((JAXXContext)this.view, I18n._((String)"coser.config.category.path", (Object[])new Object[0]));
        JDialog dialogUI = new JDialog((Frame)this.view, I18n._((String)"coser.ui.config.title", (Object[])new Object[0]));
        dialogUI.add((Component)configUI);
        dialogUI.pack();
        dialogUI.setLocationRelativeTo(this.view);
        SwingSession session = this.view.getContextValue(SwingSession.class);
        session.add((Component)dialogUI);
        dialogUI.setVisible(true);
    }

    public void showCoserWebsite() {
        CoserConfig config = this.view.getContextValue(CoserConfig.class);
        URI uri = URI.create(config.getWebsiteURL());
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException ex) {
            throw new CoserException("Can't open system browser", ex);
        }
    }

    public void showCoserWebsiteSIH() {
        CoserConfig config = this.view.getContextValue(CoserConfig.class);
        URI uri = URI.create(config.getWebFrontEnd());
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException ex) {
            throw new CoserException("Can't open system browser", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAboutView() {
        CoserConfig config = this.view.getContextValue(CoserConfig.class);
        AboutFrame aboutFrame = new AboutFrame(){

            protected Component getLicenseTab() {
                JTextArea textArea = (JTextArea)super.getLicenseTab();
                textArea.setCaretPosition(0);
                return new JScrollPane(textArea);
            }
        };
        aboutFrame.setTitle(I18n._((String)"coser.ui.about.title", (Object[])new Object[0]));
        aboutFrame.setAboutHtmlText(I18n._((String)"coser.ui.about.about", (Object[])new Object[]{config.getApplicationVersion()}));
        aboutFrame.setIconPath("/icons/logo300.png");
        aboutFrame.setIconImage(Resource.getIcon((String)"/icons/logo300.png").getImage());
        InputStream licenseStream = this.getClass().getResourceAsStream("/META-INF/coser-ui-LICENSE.txt");
        try {
            if (licenseStream != null) {
                aboutFrame.setLicenseText(IOUtils.toString((InputStream)licenseStream));
            } else {
                aboutFrame.setLicenseText("No license file found");
            }
        }
        catch (IOException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't read licence file", (Throwable)ex);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)licenseStream);
        }
        aboutFrame.setBackgroundColor(Color.WHITE);
        aboutFrame.setSize(600, 600);
        aboutFrame.setLocationRelativeTo((Component)this.view);
        aboutFrame.setVisible(true);
    }

    public void showValidatorsConfiguration() {
        CoserConfig config = this.view.getContextValue(CoserConfig.class);
        ValidatorDialog validatorDialog = new ValidatorDialog((JAXXContext)this.view);
        validatorDialog.setHandler(new OptionHandler());
        if (!config.getValidatorsDirectory().isDirectory()) {
            validatorDialog.getNoCopiedToDiskLayer().setUI((LayerUI)new NoCopiedLayerUI(validatorDialog));
        }
        validatorDialog.setLocationRelativeTo(this.view);
        SwingSession session = this.view.getContextValue(SwingSession.class);
        session.add((Component)validatorDialog);
        validatorDialog.setVisible(true);
    }

    public void closeProject() {
        this.view.setProject(null);
        this.view.removeContextValue(Project.class);
        this.view.setTitle(I18n._((String)"coser.ui.mainview.titleempty", (Object[])new Object[0]));
        this.showHomeView();
    }

    public void projectLoaded(Project project) {
        this.view.setProject(project);
        this.view.setContextValue(project);
        this.view.setTitle(I18n._((String)"coser.ui.mainview.titleproject", (Object[])new Object[]{project.getName()}));
    }

    public void showSummaryView() {
        Project project = this.view.getContextValue(Project.class);
        ProjectSummaryView projectSummaryView = new ProjectSummaryView((JAXXContext)this.view);
        projectSummaryView.setHandler(new ProjectHandler());
        projectSummaryView.setProject(project);
        int selectionCount = 0;
        int resultCount = 0;
        for (Selection selection : project.getSelections().values()) {
            ++selectionCount;
            resultCount += selection.getRsufiResults().size();
        }
        projectSummaryView.getProjectSelectionCount().setText(String.valueOf(selectionCount));
        projectSummaryView.getProjectResultCount().setText(String.valueOf(resultCount));
        this.setMainComponent((Component)((Object)projectSummaryView));
    }

    public void showControlView() {
        this.showControlView(true);
    }

    public void showControlView(boolean reloadData) {
        ProjectService projectService = this.view.getContextValue(ProjectService.class);
        Project project = this.view.getContextValue(Project.class);
        this.setWaitCursor(this.view);
        try {
            if (reloadData) {
                project = projectService.loadControlData(project);
            }
            ControlView controlView = new ControlView((JAXXContext)this.view);
            controlView.setHandler(new ControlHandler());
            controlView.setControl(project.getControl());
            SwingSession session = this.view.getContextValue(SwingSession.class);
            session.add((Component)((Object)controlView));
            this.setMainComponent((Component)((Object)controlView));
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't load control data", ex);
        }
        finally {
            this.setDefaultCursor(this.view);
        }
    }

    public void showSelectionView() {
        ProjectService projectService = this.view.getContextValue(ProjectService.class);
        Project project = this.view.getContextValue(Project.class);
        this.setWaitCursor(this.view);
        try {
            Selection selection = projectService.initProjectSelection(project);
            this.view.setContextValue(selection);
            SelectionView selectionView = new SelectionView((JAXXContext)this.view);
            selectionView.setSelection(selection);
            selectionView.getSelectionDetailsTab().getValidatorSelection().setBean((Object)selection);
            SelectionHandler handler = new SelectionHandler();
            selectionView.setHandler(handler);
            handler.initMap(selectionView.getSelectionDetailsTab());
            handler.initSelection(selectionView);
            SwingSession session = this.view.getContextValue(SwingSession.class);
            session.add((Component)selectionView);
            selectionView.setSelectedIndex(0);
            this.setMainComponent(selectionView);
        }
        catch (CoserBusinessException ex) {
            JOptionPane.showMessageDialog(this.view, ex.getMessage(), I18n._((String)"coser.ui.selection.createError", (Object[])new Object[0]), 0);
            throw new CoserException("Can't create new selection", ex);
        }
        finally {
            this.setDefaultCursor(this.view);
        }
    }

    public void showSelectionView(String selectionName) {
        ProjectService projectService = this.view.getContextValue(ProjectService.class);
        Project project = this.view.getContextValue(Project.class);
        Selection selection = (Selection)project.getSelections().get(selectionName);
        this.setWaitCursor(this.view);
        try {
            project = projectService.loadSelectionData(project, selection);
            this.view.setContextValue(selection);
            SelectionView selectionView = new SelectionView((JAXXContext)this.view);
            selectionView.setSelection(selection);
            selectionView.getSelectionDetailsTab().getValidatorSelection().setBean((Object)selection);
            SelectionHandler handler = new SelectionHandler();
            selectionView.setHandler(handler);
            handler.initMap(selectionView.getSelectionDetailsTab());
            handler.reloadSelection(selectionView);
            SwingSession session = this.view.getContextValue(SwingSession.class);
            session.add((Component)selectionView);
            selectionView.setSelectedIndex(0);
            this.setMainComponent(selectionView);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't reload selection data", ex);
        }
        finally {
            this.setDefaultCursor(this.view);
        }
    }

    public void replaySelection() {
        ProjectService projectService = this.view.getContextValue(ProjectService.class);
        Project project = this.view.getContextValue(Project.class);
        CoserConfig config = this.view.getContextValue(CoserConfig.class);
        JFileChooser selectionChooser = new JFileChooser(config.getProjectsDirectory());
        selectionChooser.setFileFilter(new SelectionFileFilter());
        selectionChooser.setMultiSelectionEnabled(false);
        int result = selectionChooser.showOpenDialog(this.view);
        if (result == 0) {
            File selectionFile = selectionChooser.getSelectedFile();
            try {
                Selection selection = projectService.initProjectSelectionFromFile(project, selectionFile);
                this.view.setContextValue(selection);
                SelectionView selectionView = new SelectionView((JAXXContext)this.view);
                selectionView.setSelection(selection);
                selectionView.getSelectionDetailsTab().getValidatorSelection().setBean((Object)selection);
                SelectionHandler handler = new SelectionHandler();
                selectionView.setHandler(handler);
                handler.initMap(selectionView.getSelectionDetailsTab());
                handler.initSelection(selectionView);
                SwingSession session = this.view.getContextValue(SwingSession.class);
                session.add((Component)selectionView);
                selectionView.setSelectedIndex(0);
                this.setMainComponent(selectionView);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.view, ex.getMessage(), I18n._((String)"coser.ui.selection.replayerror", (Object[])new Object[0]), 0);
                throw new CoserException("Can't replay selection", ex);
            }
        }
    }

    public void saveLookAndFeelConfiguration(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("lookAndFeel")) {
            CoserConfig config = this.view.getContextValue(CoserConfig.class);
            config.setLookAndFeel((String)event.getNewValue());
            config.saveForUser(new String[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Look and feel saved to " + config.getLookAndFeel()));
            }
        }
    }

    public void showPublishResultView() {
        SelectUploadResultView selectUploadResultView = new SelectUploadResultView((JAXXContext)this.view);
        ResultHandler handler = new ResultHandler();
        selectUploadResultView.setHandler(handler);
        handler.init(selectUploadResultView);
        SwingSession session = this.view.getContextValue(SwingSession.class);
        session.add((Component)((Object)selectUploadResultView));
        this.setMainComponent((Component)((Object)selectUploadResultView));
    }

    public static class SelectionFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return f.getName().endsWith(".selection");
        }

        @Override
        public String getDescription() {
            return I18n._((String)"coser.ui.selection.selectionFilterDescription", (Object[])new Object[0]);
        }
    }
}

