/*
 * #%L
 * $Id: ResultTableRenderer.java 638 2011-02-01 17:12:16Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/coser/tags/coser-1.0.6/coser-ui/src/main/java/fr/ifremer/coser/ui/result/ResultTableRenderer.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.result;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.ui.selection.SelectionRsufiView;

/**
 * Selection result table renderer.
 * 
 * @author chatellier
 * @version $Revision: 638 $
 * 
 * Last update : $Date: 2011-02-01 18:12:16 +0100 (mar., 01 févr. 2011) $
 * By : $Author: chatellier $
 */
public class ResultTableRenderer extends DefaultTableCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -9030155088814184637L;

    protected SelectionRsufiView view;

    public ResultTableRenderer(SelectionRsufiView view) {
        this.view = view;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {

        Object localValue = value;
        
        switch (column) {
            case 2:
                if (value != null) {
                    // get web service
                    try {
                        WebService webService = view.getContextValue(WebService.class);
                        localValue = webService.getZoneFullName((String)value);
                    } catch (CoserBusinessException ex) {
                        throw new CoserException("Can't get zone name", ex);
                    }
                }
                break;
            case 5:
            case 6:
                boolean availale = (Boolean)value;
                if (availale) {
                    localValue = _("coser.ui.common.yes");
                }
                else {
                    localValue = _("coser.ui.common.no");
                }
                break;
        }
        return super.getTableCellRendererComponent(table, localValue, isSelected, hasFocus,
                row, column);
    }
}
