/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.result;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.bean.RSufiResultPath;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.ui.common.CommonHandler;
import fr.ifremer.coser.ui.result.ExportUploadDialog;
import fr.ifremer.coser.ui.result.RsufiResultRenderer;
import fr.ifremer.coser.ui.result.RsufiResultZoneRenderer;
import fr.ifremer.coser.ui.result.SelectUploadResultView;
import fr.ifremer.coser.ui.util.CoserProgressBar;
import fr.ifremer.coser.ui.util.ErrorHelper;
import fr.ifremer.coser.util.ProgressMonitor;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import jaxx.runtime.JAXXContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuiton.i18n.I18n;

public class ResultHandler
extends CommonHandler {
    public void init(SelectUploadResultView view) {
        view.getAvailableResultTable().setDefaultRenderer(String[].class, new RsufiResultRenderer());
        view.getSelectedResultTable().setDefaultRenderer(String[].class, new RsufiResultRenderer());
        view.getAvailableResultTable().setDefaultRenderer(String.class, new RsufiResultZoneRenderer(view));
        view.getSelectedResultTable().setDefaultRenderer(String.class, new RsufiResultZoneRenderer(view));
        this.updateAvailableResultsFilter(view);
        view.getSelectedResultTableModel().setResultPaths(new ArrayList<RSufiResultPath>());
    }

    public void updateAvailableResultsFilter(SelectUploadResultView view) {
        Date beginDate = view.getFilterBeginDate().getDate();
        Date endDate = view.getFilterEndDate().getDate();
        boolean onlyPubliable = view.getPubliableResults().isSelected();
        WebService webService = view.getContextValue(WebService.class);
        try {
            List results = webService.findAllProjectWithResult(beginDate, endDate, onlyPubliable);
            view.getAvailableResultTableModel().setResultPaths(results);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't get results", ex);
        }
    }

    public void addAvailableResult(SelectUploadResultView view) {
        int[] selectedAvailableRows;
        List<RSufiResultPath> currentResult = view.getSelectedResultTableModel().getResultPaths();
        for (int selectedAvailableRow : selectedAvailableRows = view.getAvailableResultTable().getSelectedRows()) {
            RSufiResultPath resultData = view.getAvailableResultTableModel().getResultPaths().get(selectedAvailableRow);
            if (currentResult.contains(resultData)) continue;
            currentResult.add(resultData);
            view.getSelectedResultTableModel().getIndicatorResults().add(resultData);
        }
        view.getSelectedResultTableModel().setResultPaths(currentResult);
    }

    public void removeSelectedResult(SelectUploadResultView view) {
        List<RSufiResultPath> currentResult = view.getSelectedResultTableModel().getResultPaths();
        int[] selectedSelectedRows = view.getSelectedResultTable().getSelectedRows();
        for (int index = selectedSelectedRows.length - 1; index >= 0; --index) {
            int selectedSelectedRow = selectedSelectedRows[index];
            currentResult.remove(selectedSelectedRow);
        }
        view.getSelectedResultTableModel().setResultPaths(currentResult);
    }

    public void performUploadResult(final ExportUploadDialog view) {
        final String login = view.getUploadLogintextField().getText();
        final String password = new String(view.getUploadPasswordtextField().getPassword());
        SelectUploadResultView parentView = view.getContextValue(SelectUploadResultView.class, "parent");
        final List<RSufiResultPath> selectedResults = parentView.getSelectedResultTableModel().getResultPaths();
        final Set<RSufiResultPath> indicatorResults = parentView.getSelectedResultTableModel().getIndicatorResults();
        final Set<RSufiResultPath> mapResults = parentView.getSelectedResultTableModel().getMapResults();
        final Set<RSufiResultPath> publishDataResults = parentView.getSelectedResultTableModel().getPublishDataResults();
        if (CollectionUtils.isNotEmpty(selectedResults)) {
            SwingWorker<String, Void> task = new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() {
                    try {
                        ResultHandler.this.setWaitCursor(view);
                        CoserProgressBar progressBar = view.getUploadProgressBar();
                        WebService webService = view.getContextValue(WebService.class);
                        String status = webService.performResultUpload(selectedResults, indicatorResults, mapResults, publishDataResults, login, password, (ProgressMonitor)progressBar);
                        return status;
                    }
                    catch (CoserBusinessException ex) {
                        throw new CoserException(ex.getMessage(), ex);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    try {
                        String status = (String)this.get();
                        if (StringUtils.isNotEmpty((String)status)) {
                            JOptionPane.showMessageDialog(view, I18n._((String)"coser.ui.uploadresult.resultsuploaderror", (Object[])new Object[]{status}), I18n._((String)"coser.ui.uploadresult.title", (Object[])new Object[0]), 0);
                        } else {
                            JOptionPane.showMessageDialog(view, I18n._((String)"coser.ui.uploadresult.resultsuploaded", (Object[])new Object[0]), I18n._((String)"coser.ui.uploadresult.title", (Object[])new Object[0]), 1);
                        }
                        view.dispose();
                    }
                    catch (Exception ex) {
                        ErrorHelper errorHelper = new ErrorHelper(view.getContextValue(CoserConfig.class));
                        errorHelper.showErrorDialog(view, ex.getMessage(), ex);
                    }
                    finally {
                        ResultHandler.this.setDefaultCursor(view);
                    }
                }
            };
            task.execute();
        }
    }

    public void performExtractResult(ExportUploadDialog view) {
        String extractPath = view.getExtractToTextField().getText();
        File extractDirectory = new File(extractPath);
        SelectUploadResultView parentView = view.getContextValue(SelectUploadResultView.class, "parent");
        List<RSufiResultPath> selectedResult = parentView.getSelectedResultTableModel().getResultPaths();
        Set<RSufiResultPath> publishDataResults = parentView.getSelectedResultTableModel().getPublishDataResults();
        WebService webService = view.getContextValue(WebService.class);
        try {
            this.setWaitCursor(view);
            webService.performResultExtract(selectedResult, publishDataResults, extractDirectory);
            JOptionPane.showMessageDialog(view, I18n._((String)"coser.ui.uploadresult.resultsextracted", (Object[])new Object[0]), I18n._((String)"coser.ui.uploadresult.title", (Object[])new Object[0]), 1);
            view.dispose();
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't upload results", ex);
        }
        finally {
            this.setDefaultCursor(view);
        }
    }

    public void showExportUploadDialog(SelectUploadResultView view) {
        ExportUploadDialog dialog = new ExportUploadDialog((JAXXContext)view);
        dialog.setHandler(this);
        dialog.setLocationRelativeTo((Component)((Object)view));
        dialog.setVisible(true);
    }

    public void selectExportDirectory(ExportUploadDialog view, JTextField textComponent) {
        CoserConfig config = view.getContextValue(CoserConfig.class);
        JFileChooser selectFileChooser = this.getFileChooserInstance(config.getProjectsDirectory());
        selectFileChooser.setFileSelectionMode(1);
        int result = selectFileChooser.showOpenDialog(view);
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            textComponent.setText(selectedFile.getAbsolutePath());
        }
    }
}

