/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import fr.ifremer.coser.CoserBusinessConfig;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

public class CoserConfig
extends CoserBusinessConfig {
    public CoserConfig() {
        for (CoserOption o : CoserOption.values()) {
            if (o.defaultValue == null) continue;
            this.setDefaultOption(o.key, o.defaultValue);
        }
    }

    public String getLookAndFeel() {
        String className = this.getOption(CoserOption.LOOKANDFEEL.key);
        return className;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.setOption(CoserOption.LOOKANDFEEL.key, lookAndFeel);
    }

    public String getApplicationVersion() {
        String result = this.getOption(CoserOption.APPLICATION_VERSION.key);
        return result;
    }

    public void setSupportEmail(String supportEmail) {
        this.setOption(CoserOption.SUPPORT_EMAIL.key, supportEmail);
    }

    public String getSupportEmail() {
        String result = this.getOption(CoserOption.SUPPORT_EMAIL.key);
        return result;
    }

    public String getWebsiteURL() {
        String result = this.getOption(CoserOption.WEBSITE_URL.key);
        return result;
    }

    public static enum CoserOption implements ApplicationConfig.OptionDef
    {
        CONFIG_FILE("config.file", I18n._((String)"coser.config.config.file.description", (Object[])new Object[0]), "coser.properties", String.class, true, true),
        LOOKANDFEEL("coser.lookandfeel", I18n._((String)"coser.config.lookandfeel.description", (Object[])new Object[0]), null, String.class, false, false),
        APPLICATION_VERSION("coser.application.version", I18n._((String)"coser.config.application.version.description", (Object[])new Object[0]), null, String.class, false, false),
        SUPPORT_EMAIL("coser.support.email", I18n._((String)"coser.config.support.email.description", (Object[])new Object[0]), "support@codelutin.com", String.class, false, false),
        WEBSITE_URL("coser.website", I18n._((String)"coser.config.website.description", (Object[])new Object[0]), "http://coser.labs.libre-entreprise.org/", String.class, false, false);

        protected String key;
        protected String description;
        protected String defaultValue;
        protected Class<?> type;
        protected boolean isTransient;
        protected boolean isFinal;

        private CoserOption(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isTransient = isTransient;
            this.isFinal = isFinal;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        public void setFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }
    }
}

