/*
 * #%L
 * Coselmar :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
var coselmarControllers = angular.module('coselmarControllers', ['ui.bootstrap']);

// Controller when the main page/view loads
coselmarControllers.controller("HomeCtrl", ['$scope', '$http', '$location', 'userService', 'jwtHelper',
 								function ($scope, $http, $location, userService, jwtHelper) {

	var jwtToken = localStorage.getItem('coselmar-jwt');
	if (jwtToken && !jwtHelper.isTokenExpired(jwtToken)) {
		$scope.currentUser = jwtHelper.decodeToken(jwtToken);
	}

	//Just get the version from a file
	$http.get('version.txt', {'transformResponse':angular.identity}).success(function (data) {
    	$scope.version = data;
  	});

	$scope.login = function(mail, password) {
		userService.login(mail, password, function(successResult) {
			// Store JsonWebToken to keep authentication
			localStorage.setItem('coselmar-jwt', successResult.jwt);
			$scope.currentUser = jwtHelper.decodeToken(successResult.jwt);

			// Manage login messages
			$scope.loginMessage.fail = false;

			// Redirect on '/'
			$location.path('/');

		}, function(errorResult) {
			// Error message for login
			$scope.loginMessage.fail = true;
		})
	}

	$scope.logout = function() {
		delete $scope.currentUser;
		localStorage.removeItem('coselmar-jwt');
		$location.path('/');
	}

}]);

// Controller for All Documents View
coselmarControllers.controller("DocumentsCtrl", ['$scope', '$route', '$routeParams', '$location', 'documentService', function($scope, $route, $routeParams, $location, documentService){

	//manage keywords if given
	$scope.searchKeywords = [];
	var keywords = $routeParams.keywords;
	if (Array.isArray(keywords)) {
		$scope.searchKeywords = keywords;
	} else if (keywords) {
		$scope.searchKeywords.push(keywords);
	}

	documentService.getDocuments($scope);

	$scope.deleteDocument = function(documentId){

		// Call service to create a new document
		documentService.deleteDocument(documentId, $scope, function() {
			// Go back to documents list
			$route.reload();
		});
	};

	$scope.searchDocuments = function(){
//		$route.current.params.keywords = $scope.searchKeywords;
//		$route.reload();
		$location.search('keywords', $scope.searchKeywords);
	}
}]);


// Controller for new document View
coselmarControllers.controller("NewDocumentCtrl", ['$scope', '$location', 'documentService', function($scope, $location, documentService){

	$scope.document = {'privacy': 'PUBLIC'};
	$scope.upload = {};

	$scope.createNewDocument = function(){

		// Call service to create a new document
		documentService.createDocument(
		$scope.document, $scope.upload.file, function() {
				$location.path("/documents");

			},function(error) {
				//TODO ymartel 20141118 : deal with error.status or statusText
				console.log("error occurs");
				console.log(error.s);
			});

	};
}]);

// Controller for single document View
coselmarControllers.controller("DocumentViewCtrl",
 	['$scope', '$route', '$location', 'documentService', '$routeParams', 'coselmar-config',
 	 function($scope, $route, $location, documentService, $routeParams, coselmarConfig) {

	$scope.container = {baseUrl : coselmarConfig.BASE_URL};

	documentService.getDocument($routeParams.documentId, $scope);

	$scope.deleteDocument = function(documentId){

		// Call service to create a new document
		documentService.deleteDocument(documentId, $scope, function() {
				// Go back to documents list
				$location.path("/documents");
			});

	};
} ]);

// Controller for document file download
coselmarControllers.controller("DocumentFileDlCtrl", [ '$scope','documentService', '$routeParams', function($scope, documentService, $routeParams) {
	documentService.getDocumentFile($routeParams.documentId, $scope);
} ]);

coselmarControllers.directive('ngFileModel', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var model = $parse(attrs.ngFileModel);
            var modelSetter = model.assign;

            element.bind('change', function(){
                scope.$apply(function(){
                    modelSetter(scope, element[0].files[0]);
                });
            });
        }
    };
}]);


/////////////////////////////////////////////////
//////////////  Users Part  /////////////////////
/////////////////////////////////////////////////

// Controller for All User View
coselmarControllers.controller("UsersCtrl", ['$scope', '$route', '$routeParams', '$location', 'userService', function($scope, $route, $routeParams, $location, userService){

	//manage keywords if given
	$scope.search = { searchKeyword : '', onlyActive : false };
	var keywords = $routeParams.keywords;
	if (Array.isArray(keywords)) {
		$scope.search.searchKeyword = keywords[0];
	} else if (keywords) {
		$scope.search.searchKeyword = keywords;
	}
	var onlyActive = $routeParams.onlyActive;
	if (onlyActive) {
		$scope.search.onlyActive = onlyActive;
	}

	userService.getUsers($scope);

	$scope.deleteUser = function(userId){

		userService.deleteUser(userId, $scope, function() {
			// Go back to documents list
			$route.reload();
		});
	};

	$scope.searchUsers = function(){
		$location.search('keywords', $scope.search.searchKeyword);
		$location.search('onlyActive', $scope.search.onlyActive);
	}
}]);


// Controller for new user View
coselmarControllers.controller("NewUserCtrl", ['$scope', '$route', '$location', 'userService', function($scope, $route, $location, userService){

	$scope.user = {'role' : 'expert'};

	$scope.saveUser = function(){

		// Call service to create a new user
		userService.saveUser($scope.user, function() {
			$location.path("/users");
		},function(error) {
			//TODO ymartel 20141118 : deal with error.status or statusText
			console.log("error occurs");
			console.log(error.s);
		});

		// Reload the page
		$route.reload();
	};
}]);

// Controller for single document View
coselmarControllers.controller("UserViewCtrl",
 	['$scope', '$route', '$location', 'userService', '$routeParams', function($scope, $route, $location, userService, $routeParams) {

	$scope.editMode = $routeParams.edit;
	if ($scope.editMode) {
		$scope.editPassword = true;
	}

	userService.getUser($routeParams.userId, $scope);

	$scope.deleteUser = function(userId){

		documentService.deleteUser(documentId, $scope, function() {
			// Go back to users list
			$location.path("/users");
		});

	};

	$scope.modifyUser = function(){
		$location.search("edit");
	};

	$scope.saveUser = function(){

		// Call service to create a new user
		userService.saveUser($scope.user,
		 	function() {
				// On success, reload the view page
				$location.search("");

			},function(error) {
				//TODO ymartel 20141118 : deal with error.status or statusText
				console.log("error occurs");
				console.log(error.s);
		});

	};

} ]);