package fr.ifremer.adagio.synchro.service.referential;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.meta.DatabaseColumns;
import fr.ifremer.adagio.synchro.meta.referential.ReferentialSynchroTables;
import fr.ifremer.adagio.synchro.service.AbstractSynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;

import java.util.Properties;

/**
 * <p>
 * ReferentialSynchroDatabaseConfiguration class.
 * </p>
 * 
 */
public class ReferentialSynchroDatabaseConfiguration extends AbstractSynchroDatabaseConfiguration {

	/**
	 * Temporary database
	 */
	public static String IS_TEMPORARY_DATABASE = "adagio.synchro.database.isTemporary";

	private final ReferentialSynchroContext context;

	/**
	 * <p>
	 * Constructor for ReferentialSynchroDatabaseConfiguration.
	 * </p>
	 * 
	 * @param context
	 *            a {@link fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroContext} object.
	 * @param otherBean
	 *            a {@link fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration} object.
	 */
	public ReferentialSynchroDatabaseConfiguration(ReferentialSynchroContext context, SynchroDatabaseConfiguration otherBean) {
		copy(otherBean);
		Preconditions.checkNotNull(context);
		this.context = context;
	}

	/**
	 * <p>
	 * Constructor for ReferentialSynchroDatabaseConfiguration.
	 * </p>
	 * 
	 * @param context
	 *            a {@link fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroContext} object.
	 * @param settings
	 *            a {@link java.util.Properties} object.
	 * @param isTarget
	 *            a boolean.
	 */
	public ReferentialSynchroDatabaseConfiguration(ReferentialSynchroContext context, Properties settings, boolean isTarget) {
		super(settings, isTarget);
		Preconditions.checkNotNull(context);
		this.context = context;
	}

	/**
	 * <p>
	 * Constructor for ReferentialSynchroDatabaseConfiguration.
	 * </p>
	 * 
	 * @param settings
	 *            a {@link java.util.Properties} object.
	 * @param isTarget
	 *            a boolean.
	 */
	public ReferentialSynchroDatabaseConfiguration(Properties settings, boolean isTarget) {
		super(settings, isTarget);
		this.context = null;
	}

	/**
	 * <p>
	 * getPersonId.
	 * </p>
	 * 
	 * @return a {@link java.lang.Integer} object.
	 */
	public Integer getPersonId() {
		return context == null ? null : context.getPersonId();
	}

	/** {@inheritDoc} */
	@Override
	public Integer getPersonSessionId() {
		return context == null ? null : context.getPersonSessionId();
	}

	/**
	 * <p>
	 * setIsTemporary.
	 * </p>
	 * 
	 * @param isTemporaryDatabase
	 *            a boolean.
	 */
	public void setIsTemporary(boolean isTemporaryDatabase) {
		setProperty(IS_TEMPORARY_DATABASE, String.valueOf(isTemporaryDatabase));
	}

	/**
	 * <p>
	 * getDirection.
	 * </p>
	 * 
	 * @return a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	public SynchroDirection getDirection() {
		return context == null ? null : context.getDirection();
	}

	/**
	 * <p>
	 * isIntegrityConstraintEnable.
	 * </p>
	 * 
	 * @return a boolean.
	 */
	public boolean isIntegrityConstraintEnable() {
		return !isMirrorDatabase();
	}

	public void excludeUnusedColumns() {

		// Always ignore some columns (mantis #22629)
		addColumnExclude(ReferentialSynchroTables.LOCATION_ASSOCIATION.name(), DatabaseColumns.UPDATE_DATE.name().toLowerCase());
		addColumnExclude(ReferentialSynchroTables.GEAR_ASSOCIATION.name(), DatabaseColumns.UPDATE_DATE.name().toLowerCase());
		addColumnExclude(ReferentialSynchroTables.TAXON_GROUP_HISTORICAL_RECORD.name(), DatabaseColumns.UPDATE_DATE.name().toLowerCase());
		addColumnExclude(ReferentialSynchroTables.TAXON_GROUP_INFORMATION.name(), DatabaseColumns.UPDATE_DATE.name().toLowerCase());
		addColumnExclude(ReferentialSynchroTables.GEAR_CLASSIFICATION_ASSOCIATIO.name(), DatabaseColumns.UPDATE_DATE.name().toLowerCase());

		// mantis ObsDeb #23535 - Do not override the local crypt_password
		// (otherwise we could not re-authenticate the user after the synchro)
		addColumnExclude(ReferentialSynchroTables.PERSON.name(), "crypt_password");
	}

	/** {@inheritDoc} */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(super.toString());

		sb.append("\n    person id: ").append(getPersonId());
		sb.append("\n    person session id: ").append(getPersonSessionId());

		return sb.toString();
	}
}
