package fr.ifremer.adagio.synchro.service.referential;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.synchro.service.AbstractSynchroContext;
import fr.ifremer.common.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroDirection;

import java.util.Set;

/**
 * <p>
 * ReferentialSynchroContext class.
 * </p>
 * 
 */
public class ReferentialSynchroContext extends AbstractSynchroContext<ReferentialSynchroDatabaseConfiguration> {

	/**
	 * Table to import, without check table max(update_dt) in method 'prepare()'.
	 * <p/>
	 * Useful to import old referential, when user rights changes, even if [update_dt < lastSynchroDate]
	 */
	private Set<String> tableNamesForced;

	/**
	 * <p>
	 * Constructor for ReferentialSynchroContext.
	 * </p>
	 */
	public ReferentialSynchroContext() {
		super();
	}

	/**
	 * <p>
	 * Constructor for ReferentialSynchroContext.
	 * </p>
	 * 
	 * @param delegate
	 *            a {@link fr.ifremer.common.synchro.service.SynchroContext} object.
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 * @param personId
	 *            a {@link java.lang.Integer} object.
	 */
	public ReferentialSynchroContext(SynchroContext delegate, SynchroDirection direction, Integer personId) {
		super(delegate, direction, personId);
	}

	/**
	 * <p>
	 * Constructor for ReferentialSynchroContext.
	 * </p>
	 * 
	 * @param delegate
	 *            a {@link fr.ifremer.common.synchro.service.SynchroContext} object.
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 * @param personId
	 *            a {@link java.lang.Integer} object.
	 * @param personSessionId
	 *            a {@link java.lang.Integer} object.
	 */
	public ReferentialSynchroContext(SynchroContext delegate, SynchroDirection direction, Integer personId, Integer personSessionId) {
		super(delegate, direction, personId);
		setPersonSessionId(personSessionId);
	}

	/**
	 * <p>
	 * Setter for the field <code>tableNamesForced</code>.
	 * </p>
	 * 
	 * @param tableNamesForced
	 *            a {@link java.util.Set} object.
	 */
	public void setTableNamesForced(Set<String> tableNamesForced) {
		this.tableNamesForced = tableNamesForced;
	}

	/**
	 * <p>
	 * Getter for the field <code>tableNamesForced</code>.
	 * </p>
	 * 
	 * @return a {@link java.util.Set} object.
	 */
	public Set<String> getTableNamesForced() {
		return tableNamesForced;
	}

	/** {@inheritDoc} */
	@Override
	public void copy(SynchroContext<? extends ReferentialSynchroDatabaseConfiguration> otherBean) {
		super.copy(otherBean);

		if (otherBean != null) {
			// Change database configuration class
			if (otherBean.getTarget() != null) {
				setTarget(new ReferentialSynchroDatabaseConfiguration(this, otherBean.getTarget()));
			}
			if (otherBean.getSource() != null) {
				setSource(new ReferentialSynchroDatabaseConfiguration(this, otherBean.getSource()));
			}
		}
	}
}
