package fr.ifremer.adagio.synchro.service.doc;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2017 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.vo.synchro.SynchroTableMetaVO;
import fr.ifremer.adagio.core.vo.synchro.SynchroTableRelationsVO;
import fr.ifremer.adagio.synchro.service.SynchroDirection;

import java.io.File;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

/**
 * Created by Ludovic on 07/12/2016.
 */
public interface DocSynchroService {

	void createTableRelationsFile(Properties connectionProperties, File tableRelationFileCache) throws SQLException;

	void createTableRelationsFile(Properties connectionProperties, File tableRelationFileCache, SynchroDirection synchroDirection)
			throws SQLException;

	List<SynchroTableMetaVO> getAffectedTablesForUpdateHierarchy(SynchroTableRelationsVO tableRelations, SynchroTableMetaVO table);

	List<SynchroTableMetaVO> getAffectedTablesForDeleteHierarchy(SynchroTableRelationsVO tableRelations, SynchroTableMetaVO table);
}
