package fr.ifremer.adagio.synchro.service.data;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DateUtils;

import java.util.Calendar;
import java.util.Date;

/**
 * Created by blavenie on 14/06/16.
 * 
 * @since 4.0
 */
public class DataSynchroUtils {

	/**
	 * Compute the start date : X years ago, starting at January 1th
	 * 
	 * @return a {@link java.util.Date} object.
	 */
	public static Date getDefaultStartDate() {
		int nbYearDataHistory = AdagioConfiguration.getInstance().getImportNbYearDataHistory();

		// Compute the start date : X years ago, starting at January 1th
		Date dataStartDate = DateUtils.addYears(new Date(), -1 * nbYearDataHistory);
		dataStartDate = DateUtils.truncate(dataStartDate, Calendar.YEAR);
		return dataStartDate;
	}

	/**
	 * Compute the end : last hour of the day
	 * 
	 * @return a {@link java.util.Date} object.
	 */
	public static Date getDefaultEndDate() {
		// Compute the end : last hour of the day
		Date dataEndDate = DateUtils.lastSecondOfTheDay(new Date());
		return dataEndDate;
	}
}
