package fr.ifremer.adagio.synchro.service.data;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.common.synchro.service.RejectedRow;
import fr.ifremer.common.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.common.synchro.service.SynchroResult;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;

/**
 * <p>
 * DataSynchroService interface.
 * </p>
 * 
 */
@Transactional(propagation = Propagation.SUPPORTS)
public interface DataSynchroService {

	/**
	 * Create a synchro context, from a source database directory (HSQLDB only).
	 * This use local connection properties as source properties, but change JDBC URL to use the given directory
	 * 
	 * @param sourceDbDirectory
	 *            a directory with a HSQLDB directory.
	 * @param userId
	 *            Id of the Allegro user
	 * @return a new context for synchronization
	 * @deprecated use method with enableDetele and enableInsertUpdate args
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	@Deprecated
	DataSynchroContext createSynchroContext(File sourceDbDirectory, SynchroDirection direction, int userId);

	/**
	 * Same as createSynchroContext, but with a last synchronization date
	 * 
	 * @param sourceDbDirectory
	 *            a directory with a HSQLDB directory.
	 * @param userId
	 *            Id of the Allegro user
	 * @param lastSynchronizationDate
	 *            the date of the last synchronization
	 * @return a new context for synchronization
	 * @deprecated use method with enableDetele and enableInsertUpdate args
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	@Deprecated
	DataSynchroContext createSynchroContext(File sourceDbDirectory, SynchroDirection direction, int userId, Timestamp lastSynchronizationDate);

	/**
	 * Same as createSynchroContext, but with a last synchronization date
	 * 
	 * @param sourceDbDirectory
	 *            a directory with a HSQLDB directory.
	 * @param userId
	 *            Id of the Allegro user
	 * @param lastSynchronizationDate
	 *            the date of the last synchronization
	 * @param enableDelete
	 *            need to synchronize deletion ?
	 * @param enableInsertUpdate
	 *            need to synchronize insert/update ?
	 * @return a new context for synchronization
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	DataSynchroContext createSynchroContext(File sourceDbDirectory, SynchroDirection direction, int userId, Timestamp lastSynchronizationDate,
			boolean enableDelete, boolean enableInsertUpdate);

	/**
	 * Create a synchro context, using configuration properties for target and source properties.
	 * 
	 * @param sourceConnectionProperties
	 *            Properties to use as source connection (could be Oracle, HSQLDB...)
	 * @param userId
	 *            Id of the Allegro user
	 * @return a new context for synchronization
	 * @deprecated use method with lastSynchronizationDate,enableDetele and enableInsertUpdate args
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	@Deprecated
	DataSynchroContext createSynchroContext(Properties sourceConnectionProperties, SynchroDirection direction, int userId);

	/**
	 * Same as createSynchroContext, but with a last synchronization date
	 * 
	 * @param sourceConnectionProperties
	 *            Properties to use as source connection (could be Oracle, HSQLDB...)
	 * @param userId
	 *            Id of the Allegro user
	 * @param lastSynchronizationDate
	 *            the date of the last synchronization
	 * @return a new context for synchronization
	 * @deprecated use method with lastSynchronizationDate,enableDetele and enableInsertUpdate args
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	@Deprecated
	DataSynchroContext createSynchroContext(Properties sourceConnectionProperties, SynchroDirection direction, int userId,
			Timestamp lastSynchronizationDate);

	/**
	 * Same as createSynchroContext, but with a last synchronization date
	 * 
	 * @param sourceConnectionProperties
	 *            Properties to use as source connection (could be Oracle, HSQLDB...)
	 * @param userId
	 *            Id of the Allegro user
	 * @param lastSynchronizationDate
	 *            the date of the last synchronization
	 * @param enableDelete
	 *            need to synchronize deletion ?
	 * @param enableInsertUpdate
	 *            need to synchronize insert/update ?
	 * @return a new context for synchronization
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	DataSynchroContext createSynchroContext(Properties sourceConnectionProperties, SynchroDirection direction, int userId,
			Timestamp lastSynchronizationDate, boolean enableDelete, boolean enableInsertUpdate);

	/**
	 * Prepare the synchronize operation from the target data database supported
	 * by this service, says just compute nb rows to update for each table and
	 * update the result model. <br>
	 * This method use Propagation.REQUIRES_NEW, because the transaction will be mark as rollbackOnly. (could not be set
	 * as readOnly, because of insertions into TEMP_QUERY_PARAMETER table)
	 * 
	 * @param synchroContext
	 *            Context of synchronization
	 */
	@Transactional(readOnly = false, propagation = Propagation.REQUIRES_NEW)
	void prepare(SynchroContext synchroContext);

	/**
	 * Launch the synchronize operation from the target data database supported
	 * by this service.
	 * 
	 * @param synchroContext
	 *            Context of synchronization
	 */
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED)
	void synchronize(SynchroContext synchroContext);

	/**
	 * <p>
	 * finish.
	 * </p>
	 * 
	 * @param synchroContext
	 *            a {@link fr.ifremer.common.synchro.service.SynchroContext} object.
	 * @param resultWithPendingOperation
	 *            a {@link fr.ifremer.common.synchro.service.SynchroResult} object.
	 * @param rejectStrategies
	 *            a {@link java.util.Map} object.
	 */
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED)
	void finish(SynchroContext synchroContext, SynchroResult resultWithPendingOperation,
			Map<RejectedRow.Cause, RejectedRow.ResolveStrategy> rejectStrategies);

}
