package fr.ifremer.adagio.synchro.service.data;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.technical.hibernate.ConfigurationHelper;
import fr.ifremer.adagio.synchro.meta.DatabaseColumns;
import fr.ifremer.adagio.synchro.service.AbstractSynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;

import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

/**
 * <p>
 * DataSynchroDatabaseConfiguration class.
 * </p>
 * 
 */
public class DataSynchroDatabaseConfiguration extends AbstractSynchroDatabaseConfiguration {

	/**
	 * Temporary database
	 */
	public static String IS_TEMPORARY_DATABASE = "adagio.synchro.database.isTemporary";

	/**
	 * Column remote id
	 */
	public static String COLUMN_REMOTE_ID = "synchro.database.column.remoteId";

	/**
	 * Column synchronization_status
	 */
	public static String COLUMN_SYNCHRONIZATION_STATUS = "synchro.database.column.synchronizationStatus";

	/**
	 * Attachement files
	 */
	public static String DB_ATTACHMENT_DIRECTORY = "adagio.synchro.db.attachment.directory";

	private DataSynchroContext context;

	private String columnRemoteId;

	private String columnSynchronizationStatus;

	private File dbAttachmentDirectory;

	/**
	 * <p>
	 * Constructor for DataSynchroDatabaseConfiguration.
	 * </p>
	 * 
	 * @param context
	 *            a {@link fr.ifremer.adagio.synchro.service.data.DataSynchroContext} object.
	 * @param otherBean
	 *            a {@link fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration} object.
	 */
	public DataSynchroDatabaseConfiguration(DataSynchroContext context, SynchroDatabaseConfiguration otherBean) {
		copy(otherBean);
		Preconditions.checkNotNull(context);
		this.context = context;
	}

	/**
	 * <p>
	 * Constructor for DataSynchroDatabaseConfiguration.
	 * </p>
	 * 
	 * @param context
	 *            a {@link fr.ifremer.adagio.synchro.service.data.DataSynchroContext} object.
	 * @param settings
	 *            a {@link java.util.Properties} object.
	 * @param isTarget
	 *            a boolean.
	 */
	public DataSynchroDatabaseConfiguration(DataSynchroContext context, Properties settings, boolean isTarget) {
		super(settings, isTarget);
		Preconditions.checkNotNull(context);
		this.context = context;
	}

	/**
	 * <p>
	 * Constructor for DataSynchroDatabaseConfiguration.
	 * </p>
	 * 
	 * @param settings
	 *            a {@link java.util.Properties} object.
	 * @param isTarget
	 *            a boolean.
	 */
	public DataSynchroDatabaseConfiguration(Properties settings, boolean isTarget) {
		super(settings, isTarget);
		this.context = null;
	}

	/** {@inheritDoc} */
	@Override
	protected void reloadCachedFields() {
		super.reloadCachedFields();
		this.columnRemoteId = ConfigurationHelper.getString(COLUMN_REMOTE_ID, getProperties(), "remote_id");
		this.columnSynchronizationStatus = ConfigurationHelper.getString(COLUMN_SYNCHRONIZATION_STATUS, getProperties(), "synchronization_status");

		String dbAttachmentDirProperty = ConfigurationHelper.getString(DB_ATTACHMENT_DIRECTORY, getProperties(), null);
		if (dbAttachmentDirProperty != null) {
			this.dbAttachmentDirectory = new File(dbAttachmentDirProperty);
		}
	}

	/**
	 * <p>
	 * Getter for the field <code>columnRemoteId</code>.
	 * </p>
	 * 
	 * @return a {@link java.lang.String} object.
	 */
	public String getColumnRemoteId() {
		return columnRemoteId;
	}

	/**
	 * <p>
	 * Setter for the field <code>columnRemoteId</code>.
	 * </p>
	 * 
	 * @param columnName
	 *            a {@link java.lang.String} object.
	 * @return a {@link fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration} object.
	 */
	public SynchroDatabaseConfiguration setColumnRemoteId(String columnName) {
		this.columnRemoteId = columnName;
		setProperty(COLUMN_REMOTE_ID, columnName);
		return this;
	}

	/**
	 * <p>
	 * Getter for the field <code>columnSynchronizationStatus</code>.
	 * </p>
	 * 
	 * @return a {@link java.lang.String} object.
	 */
	public String getColumnSynchronizationStatus() {
		return columnSynchronizationStatus;
	}

	/**
	 * <p>
	 * Getter for the field <code>dbAttachmentDirectory</code>.
	 * </p>
	 * 
	 * @return a {@link java.io.File} object.
	 */
	public File getDbAttachmentDirectory() {
		return dbAttachmentDirectory;
	}

	/**
	 * <p>
	 * Setter for the field <code>dbAttachmentDirectory</code>.
	 * </p>
	 * 
	 * @param dbAttachmentDirectory
	 *            a {@link java.io.File} object.
	 * @return a {@link fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration} object.
	 */
	public SynchroDatabaseConfiguration setDbAttachmentDirectory(File dbAttachmentDirectory) {
		this.dbAttachmentDirectory = dbAttachmentDirectory;
		setProperty(DB_ATTACHMENT_DIRECTORY, dbAttachmentDirectory.getPath());
		return this;
	}

	/**
	 * <p>
	 * Setter for the field <code>columnSynchronizationStatus</code>.
	 * </p>
	 * 
	 * @param columnName
	 *            a {@link java.lang.String} object.
	 * @return a {@link fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration} object.
	 */
	public SynchroDatabaseConfiguration setColumnSynchronizationStatus(String columnName) {
		this.columnSynchronizationStatus = columnName;
		setProperty(COLUMN_SYNCHRONIZATION_STATUS, columnName);
		return this;
	}

	/**
	 * <p>
	 * getPersonSessionId.
	 * </p>
	 * 
	 * @return a {@link java.lang.Integer} object.
	 */
	public Integer getPersonSessionId() {
		return context == null ? null : context.getPersonSessionId();
	}

	/**
	 * <p>
	 * getPersonId.
	 * </p>
	 * 
	 * @return a {@link java.lang.Integer} object.
	 */
	public Integer getPersonId() {
		return context == null ? null : context.getPersonId();
	}

	/**
	 * <p>
	 * setIsTemporary.
	 * </p>
	 * 
	 * @param isTemporayDatabase
	 *            a boolean.
	 */
	public void setIsTemporary(boolean isTemporayDatabase) {
		setProperty(IS_TEMPORARY_DATABASE, String.valueOf(isTemporayDatabase));
	}

	/**
	 * <p>
	 * getDataStartDate.
	 * </p>
	 * 
	 * @return a {@link java.util.Date} object.
	 */
	public Date getDataStartDate() {
		return context == null ? null : context.getDataStartDate();
	}

	/**
	 * <p>
	 * getDataEndDate.
	 * </p>
	 * 
	 * @return a {@link java.util.Date} object.
	 */
	public Date getDataEndDate() {
		return context == null ? null : context.getDataEndDate();
	}

	/**
	 * <p>
	 * getPkIncludes.
	 * </p>
	 * 
	 * @return a {@link com.google.common.collect.Multimap} object.
	 */
	public Multimap<String, String> getPkIncludes() {
		return context == null ? null : context.getPkIncludes();
	}

	/**
	 * <p>
	 * getDirection.
	 * </p>
	 * 
	 * @return a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	public SynchroDirection getDirection() {
		return context == null ? null : context.getDirection();
	}

	/**
	 * <p>
	 * getProgramCodes.
	 * </p>
	 * 
	 * @return a {@link java.util.Set} object.
	 */
	public Set<String> getProgramCodes() {
		return context == null ? null : context.getProgramCodes();
	}

	/**
	 * <p>
	 * getProgramCodes.
	 * </p>
	 * 
	 * @return a {@link java.util.Set} object.
	 */
	public int getUserProfilIdReferentailAdministrator() {
		return context == null ? null : context.getUserProfilIdReferentailAdministrator();
	}

	/**
	 * <p>
	 * isIntegrityConstraintEnable.
	 * </p>
	 * 
	 * @return a boolean.
	 */
	public boolean isIntegrityConstraintEnable() {
		return !isMirrorDatabase();
	}

	/**
	 * <p>
	 * isForceEditedRowOverride.
	 * </p>
	 * 
	 * @return a boolean.
	 */
	public boolean isForceEditedRowOverride() {
		return context == null ? null : context.isForceEditedRowOverride();
	}

	public void excludeUnusedColumns() {

		addColumnExclude(DatabaseColumns.SYNCHRONIZATION_STATUS.name().toLowerCase());
		addColumnExclude(DatabaseColumns.REMOTE_ID.name().toLowerCase());
	}

	public boolean isEnableAttachmentFiles() {
		return context == null ? null : context.isEnableAttachmentFiles();
	}

	/** {@inheritDoc} */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(super.toString());

		sb.append("\n    direction : ").append(getDirection() == null ? "" : getDirection().name());
		sb.append("\n    person id: ").append(getPersonId() == null ? "" : getPersonId());
		sb.append("\n    person session id: ").append(getPersonSessionId() == null ? "" : getPersonSessionId());
		sb.append("\n    start date: ").append(getDataStartDate());
		sb.append("\n    end date: ").append(getDataEndDate());
		sb.append("\n    program codes: ").append(getProgramCodes());
		sb.append("\n    user: ").append(getPersonId());

		return sb.toString();
	}

	/** {@inheritDoc} */
	public void copy(SynchroDatabaseConfiguration otherBean) {
		super.copy(otherBean);

		if (otherBean instanceof DataSynchroDatabaseConfiguration) {
			this.context = ((DataSynchroDatabaseConfiguration) otherBean).context;
		}
	}
}
