package fr.ifremer.adagio.synchro.service;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;

import java.util.Properties;

/**
 * <p>
 * Abstract AbstractSynchroDatabaseConfiguration class.
 * </p>
 * 
 */
public abstract class AbstractSynchroDatabaseConfiguration extends SynchroDatabaseConfiguration {

	/**
	 * <p>
	 * Constructor for AbstractSynchroDatabaseConfiguration.
	 * </p>
	 */
	protected AbstractSynchroDatabaseConfiguration() {
		super();
	}

	/**
	 * <p>
	 * Constructor for AbstractSynchroDatabaseConfiguration.
	 * </p>
	 * 
	 * @param settings
	 *            a {@link java.util.Properties} object.
	 * @param isTarget
	 *            a boolean.
	 */
	public AbstractSynchroDatabaseConfiguration(Properties settings, boolean isTarget) {
		super(settings, isTarget);
	}

	/**
	 * <p>
	 * getDirection.
	 * </p>
	 * 
	 * @return a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	public abstract SynchroDirection getDirection();

	/**
	 * <p>
	 * getPersonId.
	 * </p>
	 * 
	 * @return a {@link java.lang.Integer} object.
	 */
	public abstract Integer getPersonId();

	/**
	 * <p>
	 * getPersonSessionId.
	 * </p>
	 * 
	 * @return a {@link java.lang.Integer} object.
	 */
	public abstract Integer getPersonSessionId();
}
