package fr.ifremer.adagio.synchro.service;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.common.synchro.service.SynchroContext;

import java.util.Set;

/**
 * <p>
 * AbstractSynchroContext class.
 * </p>
 * 
 */
public class AbstractSynchroContext<C extends AbstractSynchroDatabaseConfiguration> extends SynchroContext<C> {

	private Integer personId;

	private Integer personSessionId;

	private SynchroDirection direction;

	/**
	 * Need to process deletion ?
	 */
	private boolean enableDelete = true;

	/**
	 * Need to process insert/update ?
	 */
	private boolean enableInsertOrUpdate = true;

	/**
	 * List of program codes
	 */
	protected Set<String> programCodes;

	/**
	 * <p>
	 * Constructor for AbstractSynchroContext.
	 * </p>
	 */
	public AbstractSynchroContext() {
		super();
	}

	/**
	 * <p>
	 * Constructor for AbstractSynchroContext.
	 * </p>
	 * 
	 * @param delegate
	 *            a {@link fr.ifremer.common.synchro.service.SynchroContext} object.
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 * @param personId
	 *            a {@link java.lang.Integer} object.
	 */
	public AbstractSynchroContext(SynchroContext delegate, SynchroDirection direction, Integer personId) {
		super(delegate);
		this.direction = direction;
		this.personId = personId;
		this.personSessionId = null;

	}

	/**
	 * <p>
	 * isEnableDelete.
	 * </p>
	 * 
	 * @return a boolean.
	 */
	public boolean isEnableDelete() {
		return enableDelete;
	}

	/**
	 * <p>
	 * Setter for the field <code>enableDelete</code>.
	 * </p>
	 * 
	 * @param enableDelete
	 *            a boolean.
	 */
	public void setEnableDelete(boolean enableDelete) {
		this.enableDelete = enableDelete;
	}

	/**
	 * <p>
	 * isEnableInsertOrUpdate.
	 * </p>
	 * 
	 * @return a boolean.
	 */
	public boolean isEnableInsertOrUpdate() {
		return enableInsertOrUpdate;
	}

	/**
	 * <p>
	 * Setter for the field <code>enableInsertOrUpdate</code>.
	 * </p>
	 * 
	 * @param enableInsertOrUpdate
	 *            a boolean.
	 */
	public void setEnableInsertOrUpdate(boolean enableInsertOrUpdate) {
		this.enableInsertOrUpdate = enableInsertOrUpdate;
	}

	/**
	 * <p>
	 * Getter for the field <code>personId</code>.
	 * </p>
	 * 
	 * @return a {@link java.lang.Integer} object.
	 */
	public Integer getPersonId() {
		return personId;
	}

	/**
	 * <p>
	 * Setter for the field <code>personId</code>.
	 * </p>
	 * 
	 * @param personId
	 *            a {@link java.lang.Integer} object.
	 */
	public void setPersonId(Integer personId) {
		this.personId = personId;
	}

	/**
	 * <p>
	 * Getter for the field <code>direction</code>.
	 * </p>
	 * 
	 * @return a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	public SynchroDirection getDirection() {
		return direction;
	}

	/**
	 * <p>
	 * Setter for the field <code>direction</code>.
	 * </p>
	 * 
	 * @param direction
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	public void setDirection(SynchroDirection direction) {
		this.direction = direction;
	}

	/**
	 * <p>
	 * Getter for the field <code>personSessionId</code>.
	 * </p>
	 * 
	 * @return a {@link java.lang.Integer} object.
	 */
	public Integer getPersonSessionId() {
		return personSessionId;
	}

	/**
	 * <p>
	 * Setter for the field <code>personSessionId</code>.
	 * </p>
	 * 
	 * @param personSessionId
	 *            a {@link java.lang.Integer} object.
	 */
	public void setPersonSessionId(Integer personSessionId) {
		this.personSessionId = personSessionId;
	}

	/**
	 * <p>
	 * Getter for the field <code>programCodes</code>.
	 * </p>
	 * 
	 * @return a {@link java.util.Set} object.
	 */
	public Set<String> getProgramCodes() {
		return programCodes;
	}

	/**
	 * <p>
	 * Setter for the field <code>programCodes</code>.
	 * </p>
	 * 
	 * @param programCodes
	 *            a {@link java.util.Set} object.
	 */
	public void setProgramCodes(Set<String> programCodes) {
		this.programCodes = programCodes;
	}

	/** {@inheritDoc} */
	@Override
	public void copy(SynchroContext<? extends C> otherBean) {
		super.copy(otherBean);

		if (otherBean instanceof AbstractSynchroContext) {
			this.direction = ((AbstractSynchroContext) otherBean).direction;
			this.enableDelete = ((AbstractSynchroContext) otherBean).enableDelete;
			this.enableInsertOrUpdate = ((AbstractSynchroContext) otherBean).enableInsertOrUpdate;
			this.personId = ((AbstractSynchroContext) otherBean).personId;
			this.personSessionId = ((AbstractSynchroContext) otherBean).personSessionId;
			this.programCodes = ((AbstractSynchroContext) otherBean).programCodes;
		}
	}

	/** {@inheritDoc} */
	@Override
	public String toString() {
		return new StringBuilder()
				.append(super.toString())
				.append("\n  direction: ").append(direction)
				.append("\n  enable update/insert: ").append(isEnableInsertOrUpdate())
				.append("\n  enable delete: ").append(isEnableDelete())
				.append("\n  programs: ").append(programCodes == null ? "all" : programCodes.toString())
				.append("\n  person: ").append(getPersonId())
				.append("\n  person session: ").append(getPersonSessionId())
				.toString();
	}

}
