package fr.ifremer.adagio.synchro.meta.referential;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2017 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Set;

/**
 * Referential tables to synchronize.
 * 
 * @author Benoit Lavenier (benoit.lavenier@e-is.pro)
 * @since 3.10.2
 */
public enum ReferentialSynchroTables {

	STATUS,
	QUALITY_FLAG,
	TRANSCRIBING_ITEM,
	TRANSCRIBING_ITEM_TYPE,
	TRANSCRIBING_SIDE,
	TRANSCRIBING_SYSTEM,
	UNIT,
	AGGREGATION_LEVEL,
	PARAMETER_GROUP,
	QUALITATIVE_VALUE,
	PARAMETER,
	MATRIX,
	FRACTION,
	FRACTION2MATRIX,
	METHOD,
	PMFM,
	PMFM2QUALITATIVE_VALUE,
	GEAR_CLASSIFICATION,
	GEAR_CLASSIFICATION_ASSOCIATIO,
	GEAR,
	GEAR_ASSOCIATION,
	GROUPING_CLASSIFICATION,
	GROUPING_LEVEL,
	GROUPING,
	GROUPING_ITEM,
	LOCATION_CLASSIFICATION,
	LOCATION_LEVEL,
	LOCATION_ASSOCIATION,
	LOCATION,
	LOCATION_HIERARCHY,
	LOCATION_HIERARCHY_EXCEPTION,
	TAXONOMIC_LEVEL,
	TAXON_NAME,
	TAXON_INFORMATION,
	TAXON_INFORMATION_HISTORY,
	VIRTUAL_COMPONENT,
	TAXON_NAME_HISTORY,
	REFERENCE_DOCUMENT,
	AUTHOR,
	CITATION,
	TAXON_GROUP_TYPE,
	TAXON_GROUP,
	TAXON_GROUP_HISTORICAL_RECORD,
	TAXON_GROUP_INFORMATION,
	REFERENCE_TAXON,
	ROUND_WEIGHT_CONVERSION,
	WEIGHT_LENGTH_CONVERSION,
	UNIT_CONVERSION,
	VESSEL_TYPE,
	VESSEL_REGISTRATION_PERIOD,
	VESSEL_FEATURES,
	VESSEL,
	USER_PROFIL,
	DEPARTMENT,
	PERSON,
	PERSON2USER_PROFIL,
	VESSEL_PERSON_ROLE,
	VESSEL_PERSON,
	ORDER_ITEM,
	PROGRAM,
	PROGRAM2LOCATION,
	PROGRAM2LOCATION_CLASSIF,
	ACQUISITION_LEVEL,
	PROGRAM_PRIVILEGE,
	PROGRAM2DEPARTMENT,
	PROGRAM2PERSON_EXCEPTION,
	PROGRAM2PERSON,
	STRATEGY,
	STRATEGY2MANAGER_PERSON,
	PMFM_APPLIED_STRATEGY,
	APPLIED_STRATEGY,
	PMFM_STRATEGY,
	REFERENCE_TAXON_STRATEGY,
	STRATEGY2GEAR,
	APPLIED_PERIOD,
	PRECISION_TYPE,
	NUMERICAL_PRECISION,
	PHOTO_TYPE,
	OBJECT_TYPE,
	ORDER_TYPE,
	ANALYSIS_INSTRUMENT,
	EDUCATION_GRADE,
	APPLIED_SIZE_CATEGORY,
	SALE_TYPE,
	SELLER_TYPE,
	METIER,
	DEPTH_GRADIENT,
	DISTANCE_TO_COAST_GRADIENT,
	NEARBY_SPECIFIC_AREA,
	REFERENCE_DOCUMENT2AUTHOR,
	SPATIAL_ITEM,
	SPATIAL_ITEM_TYPE,
	SPATIAL_ITEM2LOCATION,
	VESSEL_OWNER,
	VESSEL_OWNER_PERIOD,
	TAXON_GROUP_HIERARCHY,
	PERSON_SESSION,
	PERSON_SESSION_VESSEL,
	PERSON_SESSION_ITEM,
	DELETED_ITEM_HISTORY;

	/** Constant <code>tableNames</code> */
	private static Set<String> tableNames = null;

	/**
	 * <p>
	 * tableNames.
	 * </p>
	 * 
	 * @return a {@link java.util.Set} object.
	 */
	public static Set<String> tableNames() {
		if (tableNames != null) {
			return tableNames;
		}

		tableNames = Sets.newLinkedHashSet(); // Keep enumeration order
		for (ReferentialSynchroTables value : values()) {
			tableNames.add(value.name());
		}

		tableNames = ImmutableSet.copyOf(tableNames);
		return tableNames;
	}

	/**
	 * Return the list of table names to import. Will use the configuration, or if empty the default list
	 * defined in enumeration ReferentialSynchroTables.
	 * 
	 * @return a {@link java.util.Set} object.
	 */
	public static Set<String> getImportTablesIncludes() {
		Set<String> tableNames = AdagioConfiguration.getInstance().getImportReferentialTablesIncludes();
		if (CollectionUtils.isNotEmpty(tableNames)) {
			return tableNames;
		}

		return tableNames();
	}
}
