package fr.ifremer.adagio.synchro.meta.data;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2017 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Set;

/**
 * Data tables to synchronize.
 * 
 * @author Benoit Lavenier (benoit.lavenier@e-is.pro)
 * @since 3.10.2
 */
public enum DataSynchroTables {

	SCIENTIFIC_CRUISE,
	OBSERVED_LOCATION,
	OBSERVED_LOCATION2PERSON,
	DAILY_ACTIVITY_CALENDAR,
	FISHING_TRIP,
	SURVEY_MEASUREMENT,
	FISHING_TRIP2OBSERVER_PERSON,
	FISHING_TRIP_ORIGIN,
	GEAR_PHYSICAL_FEATURES,
	GEAR_PHYSICAL_MEASUREMENT,
	LANDING,
	LANDING_MEASUREMENT,
	LANDING2OBSERVER_PERSON,
	SALE,
	EXPECTED_SALE,
	SALE_MEASUREMENT,
	OPERATION,
	OPERATION_VESSEL_ASSOCIATION,
	PRODUCE,
	BATCH,
	SAMPLE,
	VESSEL_USE_FEATURES,
	VESSEL_USE_MEASUREMENT,
	GEAR_USE_FEATURES,
	GEAR_USE_MEASUREMENT,
	VESSEL_PERSON_FEATURES,
	VESSEL_PERSON_FEATURES2ROLE,
	VESSEL_PERSON,
	VESSEL_POSITION,
	FISHING_AREA,
	FISHING_AREA2REG_LOCATION,
	QUANTIFICATION_MEASUREMENT_P,
	SORTING_MEASUREMENT_P,
	QUANTIFICATION_MEASUREMENT,
	SORTING_MEASUREMENT,
	SAMPLE_MEASUREMENT,
	MEASUREMENT_FILE,
	PHOTO,
	DELETED_ITEM_HISTORY;

	/** Constant <code>tableNames</code> */
	private static Set<String> tableNames = null;

	/**
	 * <p>
	 * tableNames.
	 * </p>
	 * 
	 * @return a {@link java.util.Set} object.
	 */
	public static Set<String> tableNames() {
		if (tableNames != null) {
			return tableNames;
		}

		tableNames = Sets.newLinkedHashSet(); // Keep enumeration order
		for (DataSynchroTables value : values()) {
			tableNames.add(value.name());
		}

		tableNames = ImmutableSet.copyOf(tableNames);
		return tableNames;
	}

	/**
	 * Return the list of table names to import. Will use the configuration, or if empty the default list
	 * defined in enumeration DataSynchroTables.
	 * 
	 * @return a {@link java.util.Set} object.
	 */
	public static Set<String> getImportTablesIncludes() {
		Set<String> tableNames = AdagioConfiguration.getInstance().getImportDataTablesIncludes();
		if (CollectionUtils.isNotEmpty(tableNames)) {
			return tableNames;
		}

		return tableNames();
	}
}
