package fr.ifremer.adagio.synchro.intercept.referential;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.eventbus.Subscribe;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.adagio.synchro.meta.referential.ReferentialSynchroTables;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import fr.ifremer.adagio.synchro.service.SynchroDirection;

/**
 * <p>
 * PersonSessionInterceptor class.
 * </p>
 * 
 * @author Benoit Lavenier (benoit.lavenier@e-is.pro)
 * @since 3.5.0
 */
public class PersonSessionInterceptor extends AbstractReferentialInterceptor {

	/**
	 * <p>
	 * Constructor for PersonSessionInterceptor.
	 * </p>
	 */
	public PersonSessionInterceptor() {
		// Enable only on import (not need for export)
		super(ReferentialSynchroTables.PERSON_SESSION.name(),
				SynchroDirection.IMPORT_SERVER2TEMP,
				SynchroDirection.IMPORT_TEMP2LOCAL,
				SynchroDirection.IMPORT_NO_TEMP);
	}

	/**
	 * <p>
	 * handleLoadTable.
	 * </p>
	 * 
	 * @param e
	 *            a {@link fr.ifremer.common.synchro.meta.event.LoadTableEvent} object.
	 */
	@Subscribe
	public void handleLoadTable(LoadTableEvent e) {
		e.table.setRoot(true);
	}

	/**
	 * <p>
	 * handleCreateQuery.
	 * </p>
	 * 
	 * @param e
	 *            a {@link fr.ifremer.common.synchro.meta.event.CreateQueryEvent} object.
	 */
	@Subscribe
	public void handleCreateQuery(CreateQueryEvent e) {
		SynchroDirection direction = getConfig().getDirection();
		switch (e.queryName) {
		// Select queries : remove unsed columns
		case count:
		case countFromUpdateDate:
		case select:
		case selectFromUpdateDate:
		case selectMaxUpdateDate:
			if (direction == SynchroDirection.IMPORT_SERVER2TEMP
					|| direction == SynchroDirection.IMPORT_NO_TEMP) {
				// Limit to user current session id
				int personSessionId = checkAndGetPersonSessionId();
				e.sql = SynchroQueryBuilder.newBuilder(e.sql)
						.addWhere(SynchroQueryOperator.AND, "t.id", String.valueOf(personSessionId))
						.build();
			}
			break;

		default:
			break;
		}
	}
}
