package fr.ifremer.adagio.synchro.intercept.referential;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.tool.hbm2ddl.TableMetadata;

/**
 * <p>
 * GroupingInterceptor class.
 * </p>
 * 
 */
public class GroupingInterceptor extends AbstractReferentialInterceptor {

	/** Constant <code>COLUMN_GROUPING_CLASSIFICATION_FK="grouping_classification_fk"</code> */
	public static final String COLUMN_GROUPING_CLASSIFICATION_FK = "grouping_classification_fk";

	/** {@inheritDoc} */
	@Override
	public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
		return "GROUPING".equalsIgnoreCase(table.getName());
	}

	/**
	 * <p>
	 * handleCreateQuery.
	 * </p>
	 * 
	 * @param e
	 *            a {@link fr.ifremer.common.synchro.meta.event.CreateQueryEvent} object.
	 */
	@Subscribe
	public void handleCreateQuery(CreateQueryEvent e) {
		switch (e.queryName) {
		case count:
		case countFromUpdateDate:
		case select:
		case selectFromUpdateDate:
		case selectMaxUpdateDate:
			String groupingClassificationIds = AdagioConfiguration.getInstance().getImportGroupingClassificationIds();
			if (StringUtils.isBlank(groupingClassificationIds)) {
				groupingClassificationIds = "-1";
			}
			// Add restriction classification
			e.sql = SynchroQueryBuilder.newBuilder(e.sql)
					.addWhere(SynchroQueryOperator.AND, String.format("%s in (%s)",
							COLUMN_GROUPING_CLASSIFICATION_FK,
							groupingClassificationIds))
					.build();
			break;

		default:
			break;
		}
	}
}
