package fr.ifremer.adagio.synchro.intercept.referential;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import fr.ifremer.adagio.synchro.intercept.AbstractSynchroInterceptor;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroDatabaseConfiguration;
import org.hibernate.tool.hbm2ddl.TableMetadata;

import java.util.Set;

/**
 * <p>
 * Abstract AbstractReferentialInterceptor class.
 * </p>
 * 
 */
public abstract class AbstractReferentialInterceptor extends AbstractSynchroInterceptor<ReferentialSynchroDatabaseConfiguration> {

	/**
	 * <p>
	 * Constructor for AbstractReferentialInterceptor.
	 * </p>
	 */
	public AbstractReferentialInterceptor() {
		super();
	}

	/**
	 * <p>
	 * Constructor for AbstractReferentialInterceptor.
	 * </p>
	 * 
	 * @param directions
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	public AbstractReferentialInterceptor(SynchroDirection... directions) {
		super(directions);
	}

	/**
	 * <p>
	 * Constructor for AbstractReferentialInterceptor.
	 * </p>
	 * 
	 * @param tables
	 *            a {@link java.util.Set} object.
	 * @param directions
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	public AbstractReferentialInterceptor(Set<String> tables, SynchroDirection... directions) {
		super(tables, directions);
	}

	/**
	 * <p>
	 * Constructor for AbstractReferentialInterceptor.
	 * </p>
	 * 
	 * @param tables
	 *            a {@link java.util.Set} object.
	 */
	public AbstractReferentialInterceptor(Set<String> tables) {
		super(tables);
	}

	/**
	 * <p>
	 * Constructor for AbstractReferentialInterceptor.
	 * </p>
	 * 
	 * @param tableName
	 *            a {@link java.lang.String} object.
	 * @param directions
	 *            a {@link fr.ifremer.adagio.synchro.service.SynchroDirection} object.
	 */
	public AbstractReferentialInterceptor(String tableName, SynchroDirection... directions) {
		this(ImmutableSet.of(tableName), directions);
	}

	/**
	 * <p>
	 * Constructor for AbstractReferentialInterceptor.
	 * </p>
	 * 
	 * @param tableName
	 *            a {@link java.lang.String} object.
	 */
	public AbstractReferentialInterceptor(String tableName) {
		this(ImmutableSet.of(tableName));
	}

	/** {@inheritDoc} */
	@Override
	protected Class<ReferentialSynchroDatabaseConfiguration> getConfigClass() {
		return ReferentialSynchroDatabaseConfiguration.class;
	}

	/** {@inheritDoc} */
	@Override
	public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
		return true;
	}

}
