package fr.ifremer.adagio.synchro.intercept.data.internal;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

/**
 * Overwrite update_date column value, with a server systimestamp.
 * Only used when synchro direction is EXPORT_TEMP2SERVER
 * 
 * @author Benoit Lavenier (benoit.lavenier@e-is.pro)
 * @since 3.7.1
 */
public class ExportUpdateDateInterceptor extends SynchroInterceptorBase {
	private final int updateDateColumnIndex;
	private final Timestamp systimestamp;

	/**
	 * <p>
	 * Constructor for ExportUpdateDateInterceptor.
	 * </p>
	 * 
	 * @param updateDateColumnIndex
	 *            a int.
	 * @param systimestamp
	 *            a {@link java.sql.Timestamp} object.
	 */
	public ExportUpdateDateInterceptor(int updateDateColumnIndex, Timestamp systimestamp) {
		this.updateDateColumnIndex = updateDateColumnIndex;
		this.systimestamp = systimestamp;
		setEnableOnRead(true);
		setEnableOnWrite(true);
	}

	/** {@inheritDoc} */
	@Override
	public SynchroInterceptorBase clone() {
		return new ExportUpdateDateInterceptor(
				updateDateColumnIndex,
				systimestamp);
	}

	/** {@inheritDoc} */
	@Override
	protected void doOnRead(Object[] data, SynchroTableDao sourceDao, SynchroTableDao targetDao) throws SQLException {
		// Override systimestamp
		data[updateDateColumnIndex] = systimestamp;
	}

	/** {@inheritDoc} */
	@Override
	protected void doOnWrite(Object[] data,
			List<Object> pk,
			SynchroTableDao sourceDao,
			SynchroTableDao targetDao,
			SynchroOperationRepository operationContext,
			boolean insert) throws SQLException {
		// Override systimestamp
		data[updateDateColumnIndex] = systimestamp;
	}
}
