package fr.ifremer.adagio.synchro.intercept.data.internal;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2017 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.synchro.meta.DatabaseColumns;
import fr.ifremer.adagio.synchro.meta.data.DataSynchroTables;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;

import java.sql.SQLException;

/**
 * Inherit TableWithAttachmentsInterceptor: add a special case to optimize the join on MEASUREMENT_FILE.
 * Only one object_type if used (BATCH or CATCH_BATCH but not both), depending on the value of the column
 * BACTH.IS_CATCH_BATCH
 * Created by blavenie on 15/04/17.
 */
public class BatchAttachmentsInterceptor extends TableWithAttachmentsInterceptor {

	private int isCatchBacthColumnIndex;

	public BatchAttachmentsInterceptor(DataSynchroDatabaseConfiguration config,
			SynchroTableMetadata table) {
		this(config,
				table.getSelectColumnIndex(DatabaseColumns.ID.name()),
				table.getSelectColumnIndex(DatabaseColumns.IS_CATCH_BATCH.name()));
	}

	public BatchAttachmentsInterceptor(DataSynchroDatabaseConfiguration config,
			int pkColumnIndex,
			int isCatchBacthColumnIndex) {
		super(config, DataSynchroTables.BATCH.name(), pkColumnIndex);
		this.isCatchBacthColumnIndex = isCatchBacthColumnIndex;
	}

	@Override
	public SynchroInterceptorBase clone() {
		return new BatchAttachmentsInterceptor(
				getConfig(),
				getPkColumnIndex(),
				isCatchBacthColumnIndex);
	}

	/** {@inheritDoc} */
	@Override
	protected void doOnWrite(Object[] data,
			Object objectId,
			SynchroTableDao sourceDao,
			SynchroTableDao targetDao,
			SynchroOperationRepository buffer,
			boolean insert)
			throws SQLException {

		boolean isCatchBacth = data[isCatchBacthColumnIndex] != null && "1".equals(data[isCatchBacthColumnIndex].toString());

		// Use only ONE object type, depending on the value of IS_CATCH_BATCH column
		String objectTypeCode = isCatchBacth ? "CATCH_BATCH" : "BATCH";
		addChildToUpdateFromManyColumns(data, objectId, objectTypeCode, sourceDao, targetDao, buffer);
	}

}
