package fr.ifremer.adagio.synchro.intercept.data;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.internal.BatchAttachmentsInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.internal.TableWithAttachmentsInterceptor;
import fr.ifremer.adagio.synchro.meta.DatabaseColumns;
import fr.ifremer.adagio.synchro.meta.data.DataSynchroTables;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import org.hibernate.tool.hbm2ddl.TableMetadata;

/**
 * <p>
 * TablesWithAttachmentsInterceptor class.
 * </p>
 * 
 * @author Benoit Lavenier (benoitl.lavenier@e-is.pro)
 * @since 4.1.0
 */
public class TablesWithAttachmentsInterceptor extends AbstractDataInterceptor {

	private static final String COLUMN_ID = DatabaseColumns.ID.name();

	/** {@inheritDoc} */
	@Override
	public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
		String tableName = table.getName();
		return tableName.equalsIgnoreCase(DataSynchroTables.SCIENTIFIC_CRUISE.name())
				|| tableName.equalsIgnoreCase(DataSynchroTables.OPERATION.name())
				|| tableName.equalsIgnoreCase(DataSynchroTables.BATCH.name())
				|| tableName.equalsIgnoreCase(DataSynchroTables.SAMPLE.name());
	}

	/**
	 * <p>
	 * handleTableLoad.
	 * </p>
	 * 
	 * @param e
	 *            a {@link LoadTableEvent} object.
	 */
	@Subscribe
	public void handleTableLoad(LoadTableEvent e) {

		// Special case for attachment on BATCH table
		if (e.table.getName().equalsIgnoreCase(DataSynchroTables.BATCH.name())) {
			e.table.addInterceptor(new BatchAttachmentsInterceptor(
					getConfig(),
					e.table));
		}
		// Create a delegated interceptor for attachment files (mantis #34555)
		else {
			e.table.addInterceptor(new TableWithAttachmentsInterceptor(
					getConfig(),
					e.table.getName(),
					e.table.getSelectColumnIndex(COLUMN_ID)));
		}
	}

}
