package fr.ifremer.adagio.synchro.intercept.data;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata.DuplicateKeyStrategy;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import org.hibernate.tool.hbm2ddl.TableMetadata;

import java.util.List;

/**
 * <p>
 * GearUseFeaturesInterceptor class.
 * </p>
 * 
 * @author Benoit Lavenier (benoit.lavenier@e-is.pro)
 * @since 3.8.3
 */
public class GearUseFeaturesInterceptor extends AbstractDataInterceptor {

	private static final String TABLE = "GEAR_USE_FEATURES";
	private static final String UNIQUE_KEY_NAME = "GEAR_USE_FEATURES_UNIQUE_KEY";
	private static final List<String> UNIQUE_KEY_COLS = ImmutableList.of(
			"VESSEL_FK", "PROGRAM_FK", "GEAR_FK",
			"METIER_FK", "START_DATE", "END_DATE",
			"OPERATION_FK", "FISHING_EFFORT_CALENDAR_FK",
			"ACTIVITY_CALENDAR_FK", "DAILY_ACTIVITY_CALENDAR_FK");

	/**
	 * <p>
	 * Constructor for GearUseFeaturesInterceptor.
	 * </p>
	 */
	public GearUseFeaturesInterceptor() {
		super(SynchroDirection.EXPORT_TEMP2SERVER);
	}

	/** {@inheritDoc} */
	@Override
	public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
		return TABLE.equalsIgnoreCase(table.getName());
	}

	/**
	 * <p>
	 * handleTableLoad.
	 * </p>
	 * 
	 * @param e
	 *            a {@link fr.ifremer.common.synchro.meta.event.LoadTableEvent} object.
	 */
	@Subscribe
	public void handleTableLoad(LoadTableEvent e) {

		// Define a natural Id, on server
		if (getConfig().getDirection() == SynchroDirection.EXPORT_TEMP2SERVER) {
			// Add the unique key - mantis #23599
			e.table.addUniqueConstraint(UNIQUE_KEY_NAME, UNIQUE_KEY_COLS, DuplicateKeyStrategy.REJECT);
		}
	}

}
