package fr.ifremer.adagio.synchro.dao.data.measure;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2017 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Joiner;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by blavenie on 03/05/17.
 */
public class DbAttachmentFiles {

	public static String DB_ATTACHMENT_DIRECTORY = "meas_files";

	private static Joiner PATH_JOINER = Joiner.on('/');

	private DbAttachmentFiles() {
		// helper class
	}

	public static String getPath(String objectTypeCode, Object objectId, Object measurementFileId, String extension) {
		return PATH_JOINER.join(
				objectTypeCode.toUpperCase(),
				String.format("OBJ%s", objectId),
				String.format("%s-OBJ%s-%s",
						objectTypeCode.toUpperCase(),
						objectId,
						measurementFileId)
						+ (StringUtils.isNotBlank(extension) ? "." + extension.trim() : ""));
	}
}
