// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.synchro.dao.administration.user;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.dao.technical.jdbc.OptionalDatasourceJdbcDaoSupport;
import fr.ifremer.common.synchro.dao.Daos;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.sql.*;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

/**
 * Fill person session table (using JDBC queries, executed against the server database)
 */
@Repository("personSessionSynchroJdbcDao")
@Lazy
public class PersonSessionSynchroJdbcDaoImpl
		extends OptionalDatasourceJdbcDaoSupport
		implements PersonSessionSynchroJdbcDao, InitializingBean {

	/**
	 * @see oracle.jdbc.OracleTypes CURSOR
	 */
	private final int ORACLE_TYPE_CURSOR = -10;

	@Resource(name = "synchroQueriesJdbcProperties")
	protected Properties queriesJdbcProperties;

	/**
	 * Constructor used by Spring
	 * 
	 * @param dataSource
	 *            a {@link javax.sql.DataSource} object.
	 */
	@Autowired
	public PersonSessionSynchroJdbcDaoImpl(DataSource dataSource) {
		super(dataSource);
	}

	/**
	 * Constructor without Spring (e.g. for synchro)
	 */
	public PersonSessionSynchroJdbcDaoImpl() {
		super();
		// Load queries file
		queriesJdbcProperties = loadPropertiesFromXml("synchro-queries.jdbc.xml");

		// Check queries
		checkAllQueries();
	}

	/** {@inheritDoc} */
	@Override
	public void afterPropertiesSet() throws Exception {
		checkAllQueries();
	}

	private void checkAllQueries() {
		// Check queries exists on queries file
		checkQueryExists("personSessionIdByPerson");
		checkQueryExists("initPersonSessionCall");
	}

	/** {@inheritDoc} */
	@Override
	public int initPersonSession(Properties connectionProperties, int userId) {
		Preconditions.checkArgument(connectionProperties == null /* use datasource */||
				Daos.isOracleDatabase(Daos.getUrl(connectionProperties)),
				"Not implemented yet for non-Oracle database connection.");

		Connection connection;
		try {
			connection = createConnection(connectionProperties);
		} catch (SQLException e) {
			throw new AdagioTechnicalException("Could not connect to given database", e);
		}

		try {
			return initPersonSession(connection, userId);
		} finally {
			closeSilently(connection);
		}
	}

	/** {@inheritDoc} */
	@Override
	public int getPersonSessionIdByPerson(Properties connectionProperties, int personId) {
		Preconditions.checkArgument(Daos.isOracleDatabase(Daos.getUrl(connectionProperties)),
				"Not implemented yet for non-Oracle database connection.");

		// Find the user, by id
		String sql = queriesJdbcProperties.getProperty("personSessionIdByPerson");

		Map<String, Object> paramMap = Maps.newHashMap();
		paramMap.put("personId", personId);

		return query(connectionProperties, sql, paramMap, new ResultSetExtractor<Integer>() {
			@Override
			public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
				return rs.getInt(1);
			}
		});
	}

	/* -- Internal methods -- */

	protected int initPersonSession(Connection connection, int userId) {
		String sql = queriesJdbcProperties.getProperty("initPersonSessionCall");

		CallableStatement statement = null;
		try {

			statement = connection.prepareCall(sql);
			statement.registerOutParameter(1, ORACLE_TYPE_CURSOR);
			statement.setLong(2, (long) userId);
			// statement.setInt(3, 1); // 1=skip long duration generation
			statement.execute();
			ResultSet rs = (ResultSet) statement.getObject(1);
			rs.next();
			int personSessionId = rs.getInt(1);
			if (personSessionId == 0) {
				throw new DataRetrievalFailureException(
						String.format("Could not compute PERSON_SESSION for user with id=%s. Make sure this user exists in table PERSON.", userId));
			}

			return personSessionId;
		} catch (SQLException e) {
			throw new AdagioTechnicalException("Error while executing function F_FILL_PERSON_SESSION.", e);
		} finally {
			Daos.closeSilently(statement);
		}

	}

	/**
	 * <p>
	 * checkQueryExists.
	 * </p>
	 * 
	 * @param queryName
	 *            a {@link java.lang.String} object.
	 */
	protected void checkQueryExists(String queryName) {
		Preconditions.checkArgument(
				StringUtils.isNotBlank(queriesJdbcProperties.getProperty(queryName)),
				String.format("Property with name [%s] not exists on synchro JDBC queries file", queryName));
	}
}
