package fr.ifremer.adagio.synchro.dao.administration.user;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Date;
import java.util.Properties;

/**
 * <p>
 * PersonSessionSynchroJdbcDao interface.
 * </p>
 * 
 */
public interface PersonSessionSynchroJdbcDao {

	/**
	 * Open a new session for a new, then return the session id
	 * 
	 * @param connectionProperties
	 *            a {@link java.util.Properties} object.
	 * @param personId
	 *            a int.
	 * @return the personSessionId
	 */
	int initPersonSession(Properties connectionProperties, int personId);

	/**
	 * Open a new session for a new, then return the session id
	 * 
	 * @param connectionProperties
	 *            a {@link java.util.Properties} object.
	 * @param personId
	 *            a int.
	 * @return the personSessionId
	 */
	int getPersonSessionIdByPerson(Properties connectionProperties, int personId);
}
