/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.dao.technical.DateUtils;
import fr.ifremer.adagio.core.dao.technical.hibernate.ConfigurationHelper;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.adagio.synchro.dao.administration.user.PersonSessionSynchroJdbcDao;
import fr.ifremer.adagio.synchro.dao.administration.user.PersonSessionSynchroJdbcDaoImpl;
import fr.ifremer.adagio.synchro.intercept.data.ObjectTypeHelper;
import fr.ifremer.adagio.synchro.meta.DatabaseColumns;
import fr.ifremer.adagio.synchro.meta.data.DataSynchroTables;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroContext;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.service.data.DataSynchroService;
import fr.ifremer.adagio.synchro.service.data.DataSynchroUtils;
import fr.ifremer.common.synchro.SynchroTechnicalException;
import fr.ifremer.common.synchro.config.SynchroConfiguration;
import fr.ifremer.common.synchro.dao.DaoFactory;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.service.RejectedRow;
import fr.ifremer.common.synchro.service.SynchroContext;
import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.service.SynchroResult;
import fr.ifremer.common.synchro.service.SynchroServiceImpl;
import fr.ifremer.common.synchro.service.SynchroTableOperation;
import fr.ifremer.common.synchro.type.ProgressionModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="dataSynchroService")
@Lazy
public class DataSynchroServiceImpl
extends SynchroServiceImpl
implements DataSynchroService {
    private static final Log log = LogFactory.getLog(DataSynchroServiceImpl.class);
    private static boolean DISABLE_INTEGRITY_CONSTRAINTS = false;
    private static boolean ALLOW_MISSING_OPTIONAL_COLUMN = true;
    private static boolean ALLOW_ADDITIONAL_MANDATORY_COLUMN_IN_SOURCE_SCHEMA = false;
    private static boolean KEEP_WHERE_CLAUSE_ON_QUERIES_BY_FKS = false;
    private static final String TABLE_DELETED_ITEM_HISTORY = "DELETED_ITEM_HISTORY";
    private static final String COLUMN_SYNCHRONIZATION_STATUS = "synchronization_status";
    private static final String COLUMN_REMOTE_ID = "remote_id";
    @Resource
    private PersonSessionSynchroJdbcDao personSessionSynchroJdbcDao = null;
    @Resource
    private AdagioConfiguration adagioConfig = null;
    private final int exportUpdateDateDelayInSecond;

    @Autowired
    public DataSynchroServiceImpl(DataSource dataSource, SynchroConfiguration config) {
        super(dataSource, config, DISABLE_INTEGRITY_CONSTRAINTS, ALLOW_MISSING_OPTIONAL_COLUMN, ALLOW_ADDITIONAL_MANDATORY_COLUMN_IN_SOURCE_SCHEMA, KEEP_WHERE_CLAUSE_ON_QUERIES_BY_FKS);
        this.exportUpdateDateDelayInSecond = AdagioConfiguration.getInstance().getExportDataUpdateDateDelayInSecond();
    }

    public DataSynchroServiceImpl() {
        super(DISABLE_INTEGRITY_CONSTRAINTS, ALLOW_MISSING_OPTIONAL_COLUMN, ALLOW_ADDITIONAL_MANDATORY_COLUMN_IN_SOURCE_SCHEMA, KEEP_WHERE_CLAUSE_ON_QUERIES_BY_FKS);
        this.adagioConfig = AdagioConfiguration.getInstance();
        this.exportUpdateDateDelayInSecond = this.adagioConfig.getExportDataUpdateDateDelayInSecond();
        this.personSessionSynchroJdbcDao = new PersonSessionSynchroJdbcDaoImpl();
    }

    @Override
    public DataSynchroContext createSynchroContext(File sourceDbDirectory, SynchroDirection direction, int userId) {
        Preconditions.checkNotNull((Object)sourceDbDirectory);
        Preconditions.checkArgument((sourceDbDirectory.exists() && sourceDbDirectory.isDirectory() ? 1 : 0) != 0);
        return this.createSynchroContext(sourceDbDirectory, direction, userId, null, true, true);
    }

    @Override
    public DataSynchroContext createSynchroContext(File sourceDbDirectory, SynchroDirection direction, int userId, Timestamp lastSynchronizationDate) {
        return this.createSynchroContext(sourceDbDirectory, direction, userId, lastSynchronizationDate, true, true);
    }

    @Override
    public DataSynchroContext createSynchroContext(File sourceDbDirectory, SynchroDirection direction, int userId, Timestamp lastSynchronizationDate, boolean enableDelete, boolean enableInsertUpdate) {
        SynchroContext delegate = super.createSynchroContext(sourceDbDirectory, DataSynchroTables.getImportTablesIncludes());
        delegate.getTarget().putAllProperties((Map)AdagioConfiguration.getInstance().getConnectionProperties());
        DataSynchroContext result = new DataSynchroContext(delegate, direction, userId);
        result.setLastSynchronizationDate(lastSynchronizationDate);
        result.setEnableDelete(enableDelete);
        result.setEnableInsertOrUpdate(enableInsertUpdate);
        this.initContext(result);
        return result;
    }

    @Override
    public DataSynchroContext createSynchroContext(Properties sourceConnectionProperties, SynchroDirection direction, int userId) {
        return this.createSynchroContext(sourceConnectionProperties, direction, userId, null, true, true);
    }

    @Override
    public DataSynchroContext createSynchroContext(Properties sourceConnectionProperties, SynchroDirection direction, int userId, Timestamp lastSynchronizationDate) {
        return this.createSynchroContext(sourceConnectionProperties, direction, userId, lastSynchronizationDate, true, true);
    }

    @Override
    public DataSynchroContext createSynchroContext(Properties sourceConnectionProperties, SynchroDirection direction, int userId, Timestamp lastSynchronizationDate, boolean enableDelete, boolean enableInsertUpdate) {
        Preconditions.checkNotNull((Object)sourceConnectionProperties);
        SynchroContext delegate = super.createSynchroContext(sourceConnectionProperties, DataSynchroTables.getImportTablesIncludes());
        delegate.getTarget().putAllProperties((Map)AdagioConfiguration.getInstance().getConnectionProperties());
        DataSynchroContext result = new DataSynchroContext(delegate, direction, userId);
        result.setLastSynchronizationDate(lastSynchronizationDate);
        result.setEnableDelete(enableDelete);
        result.setEnableInsertOrUpdate(enableInsertUpdate);
        this.initContext(result);
        return result;
    }

    @Override
    public void prepare(SynchroContext synchroContext) {
        Preconditions.checkArgument((synchroContext != null && synchroContext instanceof DataSynchroContext ? 1 : 0) != 0, (Object)String.format("The context must be a instance of %s", DataSynchroContext.class.getName()));
        DataSynchroContext dataSynchroContext = (DataSynchroContext)synchroContext;
        SynchroResult result = dataSynchroContext.getResult();
        SynchroDirection direction = dataSynchroContext.getDirection();
        DataSynchroDatabaseConfiguration target = (DataSynchroDatabaseConfiguration)dataSynchroContext.getTarget();
        DataSynchroDatabaseConfiguration source = (DataSynchroDatabaseConfiguration)dataSynchroContext.getSource();
        if (direction == SynchroDirection.IMPORT_SERVER2TEMP) {
            target.setIsMirrorDatabase(true);
            target.addColumnExclude(COLUMN_SYNCHRONIZATION_STATUS);
            target.addColumnExclude(COLUMN_REMOTE_ID);
            target.addCheckSchemaTableExclude(DataSynchroTables.QUANTIFICATION_MEASUREMENT.name());
            source.addCheckSchemaTableExclude(DataSynchroTables.QUANTIFICATION_MEASUREMENT.name());
            this.disableIntegrityConstraints(target.getConnectionProperties(), result);
            if (!result.isSuccess()) {
                return;
            }
            source.setCheckUniqueConstraintBetweenInputRows(false);
            target.setCheckUniqueConstraintBetweenInputRows(false);
            if (dataSynchroContext.getPersonSessionId() == null) {
                this.fillPersonSessionId(dataSynchroContext, result);
                if (!result.isSuccess()) {
                    return;
                }
            }
            if (dataSynchroContext.getDataStartDate() == null || dataSynchroContext.getDataEndDate() == null) {
                this.fillDefaultDataPeriod(dataSynchroContext);
            }
            if (dataSynchroContext.getPkIncludes() == null) {
                this.fillDefaultPkIncludes(dataSynchroContext);
            }
        } else if (direction == SynchroDirection.IMPORT_TEMP2LOCAL) {
            target.setIsMirrorDatabase(false);
            source.setCheckUniqueConstraintBetweenInputRows(false);
            target.setCheckUniqueConstraintBetweenInputRows(false);
        } else if (direction == SynchroDirection.EXPORT_LOCAL2TEMP) {
            target.setIsMirrorDatabase(true);
            this.disableIntegrityConstraints(target.getConnectionProperties(), result);
            if (!result.isSuccess()) {
                return;
            }
            source.setCheckUniqueConstraintBetweenInputRows(false);
            target.setCheckUniqueConstraintBetweenInputRows(false);
        } else if (direction == SynchroDirection.EXPORT_TEMP2SERVER) {
            source.addColumnExclude(COLUMN_SYNCHRONIZATION_STATUS);
            source.addColumnExclude(COLUMN_REMOTE_ID);
            source.setFullMetadataEnable(true);
            target.addCheckSchemaTableExclude(DataSynchroTables.QUANTIFICATION_MEASUREMENT.name());
            source.addCheckSchemaTableExclude(DataSynchroTables.QUANTIFICATION_MEASUREMENT.name());
            target.setIsMirrorDatabase(false);
            target.setFullMetadataEnable(false);
            this.fillSystemTimestampWithDelay(result, target);
            source.setSystemTimestamp(target.getSystemTimestamp());
        }
        super.prepare(synchroContext);
    }

    @Override
    public void synchronize(SynchroContext synchroContext) {
        boolean synchronizeUsingBatch;
        Preconditions.checkArgument((synchroContext != null && synchroContext instanceof DataSynchroContext ? 1 : 0) != 0, (Object)String.format("The context must be a instance of %s", DataSynchroContext.class.getName()));
        DataSynchroContext dataSynchroContext = (DataSynchroContext)synchroContext;
        SynchroResult result = dataSynchroContext.getResult();
        List<Multimap<String, String>> pkIncludesListForBatch = null;
        DataSynchroDatabaseConfiguration target = (DataSynchroDatabaseConfiguration)dataSynchroContext.getTarget();
        DataSynchroDatabaseConfiguration source = (DataSynchroDatabaseConfiguration)dataSynchroContext.getSource();
        if (dataSynchroContext.getDirection() == SynchroDirection.IMPORT_SERVER2TEMP) {
            target.removeColumnExclude(COLUMN_SYNCHRONIZATION_STATUS);
            target.removeColumnExclude(COLUMN_REMOTE_ID);
            this.disableIntegrityConstraints(dataSynchroContext.getTarget().getConnectionProperties(), result);
            if (!result.isSuccess()) {
                return;
            }
        } else if (dataSynchroContext.getDirection() == SynchroDirection.EXPORT_TEMP2SERVER) {
            source.removeColumnExclude(COLUMN_SYNCHRONIZATION_STATUS);
            source.removeColumnExclude(COLUMN_REMOTE_ID);
        } else if (dataSynchroContext.getDirection() == SynchroDirection.IMPORT_TEMP2LOCAL && dataSynchroContext.isEnableInsertOrUpdate() && (dataSynchroContext.getPkIncludes() == null || dataSynchroContext.getPkIncludes().isEmpty())) {
            pkIncludesListForBatch = this.computePkIncludesListForBatch(result, dataSynchroContext);
        }
        if (!(synchronizeUsingBatch = CollectionUtils.isNotEmpty(pkIncludesListForBatch)) || !dataSynchroContext.isEnableInsertOrUpdate()) {
            super.synchronize(synchroContext);
        } else {
            this.synchronizeUsingBatch(synchroContext, pkIncludesListForBatch);
        }
    }

    protected void initContext(SynchroContext context) {
        context.getSource().setColumnUpdateDate(DatabaseColumns.UPDATE_DATE.name().toLowerCase());
        context.getTarget().setColumnUpdateDate(DatabaseColumns.UPDATE_DATE.name().toLowerCase());
    }

    protected void prepareRootTable(DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroTableMetadata table, SynchroContext context, SynchroResult result) throws SQLException {
        DataSynchroContext dataContext = (DataSynchroContext)context;
        if (dataContext.isEnableInsertOrUpdate() && (dataContext.isEnableDelete() || !TABLE_DELETED_ITEM_HISTORY.equalsIgnoreCase(table.getName()))) {
            super.prepareRootTable(sourceDaoFactory, targetDaoFactory, table, context, result);
        }
        if (dataContext.isEnableDelete() && !TABLE_DELETED_ITEM_HISTORY.equalsIgnoreCase(table.getName())) {
            this.prepareRootTableDeletes(sourceDaoFactory, targetDaoFactory, table, context, result);
        }
    }

    protected void prepareRootTableDeletes(DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroTableMetadata table, SynchroContext context, SynchroResult result) throws SQLException {
        String tableName = table.getName();
        Set<String> objectTypeFks = ObjectTypeHelper.getObjectTypeFromTableName(tableName);
        if (CollectionUtils.isEmpty(objectTypeFks)) {
            return;
        }
        SynchroTableDao dihSourceDao = sourceDaoFactory.getSourceDao(TABLE_DELETED_ITEM_HISTORY);
        ArrayList columnValues = Lists.newArrayListWithCapacity((int)objectTypeFks.size());
        for (String objectTypeFk : objectTypeFks) {
            columnValues.add(ImmutableList.of((Object)objectTypeFk));
        }
        Map<String, Object> bindings = this.createSelectBindingsForTable(context, TABLE_DELETED_ITEM_HISTORY);
        long count = dihSourceDao.countDataByFks((Set)ImmutableSet.of((Object)"OBJECT_TYPE_FK"), (List)columnValues, bindings);
        if (count > 0L) {
            result.addRows(tableName, (int)count);
        }
    }

    protected Map<String, Object> createDefaultSelectBindings(SynchroContext context) {
        Map bindings = super.createDefaultSelectBindings(context);
        if (context instanceof DataSynchroContext) {
            DataSynchroContext dataContext = (DataSynchroContext)context;
            bindings.put("userId", dataContext.getPersonId());
            if (dataContext.getDataStartDate() != null) {
                bindings.put("startDate", new Timestamp(dataContext.getDataStartDate().getTime()));
                bindings.put("endDate", new Timestamp(dataContext.getDataEndDate().getTime()));
            }
        }
        return bindings;
    }

    protected Map<String, Object> createSelectBindingsForTable(SynchroContext context, String tableName) {
        boolean enableUpdateDateFilter;
        HashMap bindings = Maps.newHashMap((Map)this.getSelectBindings(context));
        Timestamp lastSynchronizationDate = context.getLastSynchronizationDate();
        boolean notEmptyTargetTable = context.getResult().getUpdateDate(tableName) != null;
        boolean bl = enableUpdateDateFilter = lastSynchronizationDate != null && (context.getTarget().isMirrorDatabase() || notEmptyTargetTable);
        if (enableUpdateDateFilter) {
            bindings.put("updateDate", lastSynchronizationDate);
        }
        return bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillSystemTimestampWithDelay(SynchroResult result, SynchroDatabaseConfiguration databaseConfiguration) {
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.synchro.synchronizeData.initSystemTimestamp", (Object[])new Object[0]));
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"adagio.synchro.synchronizeData.initSystemTimestamp", (Object[])new Object[0]));
        }
        Connection connection = null;
        try {
            connection = this.createConnection(databaseConfiguration);
            Dialect dialect = databaseConfiguration.getDialect();
            Timestamp currentTimestamp = DaoUtils.getCurrentTimestamp((Connection)connection, (Dialect)dialect);
            DateUtils.addSeconds((Date)currentTimestamp, (int)this.exportUpdateDateDelayInSecond);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Current timestamp: %s", currentTimestamp));
            }
            databaseConfiguration.setSystemTimestamp(currentTimestamp);
        }
        catch (AdagioTechnicalException e) {
            result.setError((Exception)((Object)e));
        }
        catch (SQLException e) {
            result.setError((Exception)e);
        }
        finally {
            this.closeSilently(connection);
        }
    }

    protected void fillDefaultDataPeriod(DataSynchroContext dataSynchroContext) {
        dataSynchroContext.setDataStartDate(DataSynchroUtils.getDefaultStartDate());
        dataSynchroContext.setDataEndDate(DataSynchroUtils.getDefaultEndDate());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Context has no start date for data import: will use default period, from [%s] to [%s]", dataSynchroContext.getDataStartDate(), dataSynchroContext.getDataEndDate()));
        }
    }

    protected void fillDefaultPkIncludes(DataSynchroContext dataSynchroContext) {
        String confProperty = this.adagioConfig.getImportDataPkIncludes();
        Multimap pkIncludes = ConfigurationHelper.getMultimap((String)confProperty);
        dataSynchroContext.setPkIncludes((Multimap<String, String>)pkIncludes);
    }

    protected List<SynchroTableOperation> getRootOperations(DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroDatabaseMetadata dbMeta, SynchroContext context) throws SQLException {
        DataSynchroContext dataContext = (DataSynchroContext)context;
        ArrayList result = Lists.newArrayList();
        if (dataContext.isEnableDelete() && (dataContext.getDirection() == SynchroDirection.EXPORT_TEMP2SERVER || dataContext.getDirection() == SynchroDirection.IMPORT_TEMP2LOCAL)) {
            Collection<SynchroTableOperation> deletedItemOperations = this.getDeleteOperations(sourceDaoFactory, targetDaoFactory, dbMeta, dataContext);
            result.addAll(deletedItemOperations);
        }
        if (dataContext.isEnableInsertOrUpdate()) {
            List defaultOperations = super.getRootOperations(sourceDaoFactory, targetDaoFactory, dbMeta, context);
            result.addAll(defaultOperations);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SynchroTableOperation> getDeleteOperations(DaoFactory sourceDaoFactory, DaoFactory targetDaoFactory, SynchroDatabaseMetadata dbMeta, DataSynchroContext context) throws SQLException {
        Preconditions.checkArgument((boolean)dbMeta.getConfiguration().isFullMetadataEnable());
        ArrayDeque result = Queues.newArrayDeque();
        SynchroTableDao dihSourceDao = sourceDaoFactory.getSourceDao(TABLE_DELETED_ITEM_HISTORY);
        Set<String> includedDataTables = DataSynchroTables.getImportTablesIncludes();
        Map<String, Object> bindings = this.createSelectBindingsForTable(context, TABLE_DELETED_ITEM_HISTORY);
        ResultSet dihResultSet = null;
        ArrayList dihIdsToRemove = Lists.newArrayList();
        try {
            dihResultSet = dihSourceDao.getData(bindings);
            while (dihResultSet.next()) {
                long dihId = dihResultSet.getLong("ID");
                String objectType = dihResultSet.getString("OBJECT_TYPE_FK");
                String tableName = ObjectTypeHelper.getTableNameFromObjectType(objectType);
                boolean isDataTable = StringUtils.isNotBlank((CharSequence)tableName) && includedDataTables.contains(tableName.toUpperCase());
                if (!isDataTable) continue;
                SynchroTableDao targetDao = targetDaoFactory.getSourceDao(tableName);
                SynchroTableMetadata table = targetDao.getTable();
                boolean shouldDeleteUsingRemoteId = context.getDirection() == SynchroDirection.IMPORT_TEMP2LOCAL;
                String objectCode = dihResultSet.getString("OBJECT_CODE");
                String objectId = dihResultSet.getString("OBJECT_ID");
                if (!StringUtils.isNotBlank((CharSequence)objectCode) && !StringUtils.isNotBlank((CharSequence)objectId)) continue;
                ImmutableList pk = StringUtils.isNotBlank((CharSequence)objectCode) ? ImmutableList.of((Object)objectCode) : ImmutableList.of((Object)objectId);
                boolean hasChildTables = targetDao.getTable().hasChildJoins();
                SynchroTableOperation operation = new SynchroTableOperation(tableName, (SynchroContext)context);
                operation.setEnableProgress(true);
                result.add(operation);
                if (shouldDeleteUsingRemoteId) {
                    if (table.getColumnIndex(COLUMN_REMOTE_ID) != -1) {
                        operation.addChildrenToDeleteFromOneColumn(tableName, COLUMN_REMOTE_ID, (List)pk);
                        dihIdsToRemove.add(dihId);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)String.format("[%s] Found deleted items on table [%s] (pk: [%s]) but no column [%s] exists on this table. Skipping this deleted items.", TABLE_DELETED_ITEM_HISTORY, tableName, SynchroTableMetadata.toPkStr((Collection)pk), COLUMN_REMOTE_ID));
                    continue;
                }
                operation.addMissingDelete((List)pk);
                if (!hasChildTables) continue;
                this.addDeleteChildrenToDeque(table, (List)ImmutableList.of((Object)pk), result, context);
            }
        }
        finally {
            Daos.closeSilently((ResultSet)dihResultSet);
        }
        if (CollectionUtils.isNotEmpty((Collection)dihIdsToRemove)) {
            SynchroTableOperation operation = new SynchroTableOperation(TABLE_DELETED_ITEM_HISTORY, (SynchroContext)context);
            operation.addChildrenToDeleteFromOneColumn(TABLE_DELETED_ITEM_HISTORY, COLUMN_REMOTE_ID, (List)dihIdsToRemove);
            result.add(operation);
        }
        return result;
    }

    protected void fillPersonSessionId(DataSynchroContext dataSynchroContext, SynchroResult result) {
        try {
            int personSessionId = this.personSessionSynchroJdbcDao.getPersonSessionIdByPerson(dataSynchroContext.getSource().getConnectionProperties(), dataSynchroContext.getPersonId());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Person session id: %s", personSessionId));
            }
            dataSynchroContext.setPersonSessionId(personSessionId);
        }
        catch (AdagioTechnicalException e) {
            result.setError((Exception)((Object)e));
        }
    }

    protected void resolveTableRow(SynchroTableMetadata table, RejectedRow reject, RejectedRow.ResolveStrategy rejectStrategy, DaoFactory daoFactory, SynchroTableOperation operation, SynchroContext context, SynchroResult result) {
        super.resolveTableRow(table, reject, rejectStrategy, daoFactory, operation, context, result);
        boolean hasSynchronizationStatus = table.getColumnNames().contains(COLUMN_SYNCHRONIZATION_STATUS);
        DataSynchroContext dataSynchroContext = (DataSynchroContext)context;
        if (hasSynchronizationStatus && dataSynchroContext.getDirection().isExport() && reject.cause == RejectedRow.Cause.BAD_UPDATE_DATE && rejectStrategy == RejectedRow.ResolveStrategy.KEEP_LOCAL) {
            operation.addMissingColumnUpdate(COLUMN_SYNCHRONIZATION_STATUS, reject.targetPkStr, (Object)SynchronizationStatus.READY_TO_SYNCHRONIZE.getValue());
        }
    }

    protected void detachRows(SynchroTableDao targetDao, List<List<Object>> pks, SynchroContext context, SynchroResult result, Deque<SynchroTableOperation> pendingOperations) throws SQLException {
        super.detachRows(targetDao, pks, context, result, pendingOperations);
        SynchroTableMetadata table = targetDao.getTable();
        boolean hasSynchronizationStatus = table.getColumnNames().contains(COLUMN_SYNCHRONIZATION_STATUS);
        boolean hasRemoteId = table.getColumnNames().contains(COLUMN_REMOTE_ID);
        if (!hasSynchronizationStatus && !hasRemoteId) {
            return;
        }
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        String readyToSynchronize = SynchronizationStatus.READY_TO_SYNCHRONIZE.getValue();
        int countR = 0;
        if (hasRemoteId) {
            for (List<Object> pk : pks) {
                targetDao.executeUpdateColumn(COLUMN_REMOTE_ID, pk, null);
                this.reportProgress(result, targetDao, ++countR, tablePrefix);
            }
        }
        if (hasSynchronizationStatus) {
            for (List<Object> pk : pks) {
                targetDao.executeUpdateColumn(COLUMN_SYNCHRONIZATION_STATUS, pk, (Object)readyToSynchronize);
                this.reportProgress(result, targetDao, ++countR, tablePrefix);
            }
        }
        if (countR == 0) {
            return;
        }
        targetDao.flush();
        result.addTableName(tableName);
        result.addUpdates(tableName, countR);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (detachment: %s)", tablePrefix, countR, countR));
        }
        if (targetDao.getCurrentOperation().isEnableProgress()) {
            result.getProgressionModel().increments(countR % this.batchSize);
        }
    }

    protected List<Multimap<String, String>> computePkIncludesListForBatch(SynchroResult resultAfterPrepare, SynchroContext context) {
        ArrayList arrayList;
        int maxRootRowCount = this.adagioConfig.getImportDataMaxRootRowCount();
        if (MapUtils.isEmpty((Map)resultAfterPrepare.getUpdateDateHits()) || maxRootRowCount <= 0 || resultAfterPrepare.getTotalRows() <= maxRootRowCount) {
            return null;
        }
        Preconditions.checkNotNull((Object)context);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Compute PKs to import, by batch of %s rows", maxRootRowCount));
        }
        SynchroDatabaseConfiguration source = context.getSource();
        Preconditions.checkNotNull((Object)source);
        Connection sourceConnection = null;
        DaoFactory sourceDaoFactory = null;
        SynchroDatabaseMetadata dbMeta = null;
        ResultSet dataToUpdate = null;
        try {
            Set tableNames = resultAfterPrepare.getUpdateDateHits().keySet();
            ArrayList result = Lists.newArrayList();
            sourceConnection = this.createConnection(source);
            log.debug((Object)"Loading source database metadata...");
            boolean isFullMetadataEnable = source.isFullMetadataEnable();
            source.setFullMetadataEnable(true);
            dbMeta = this.loadDatabaseMetadata(sourceConnection, source, tableNames);
            source.setFullMetadataEnable(isFullMetadataEnable);
            sourceDaoFactory = this.newDaoFactory(sourceConnection, source, dbMeta);
            ArrayListMultimap currentBatch = ArrayListMultimap.create();
            int currentBatchSize = 0;
            for (String tableName : tableNames) {
                SynchroTableDao sourceDao = sourceDaoFactory.getSourceDao(tableName);
                Map<String, Object> bindings = this.createSelectBindingsForTable(context, tableName);
                dataToUpdate = sourceDao.getData(bindings);
                while (dataToUpdate.next()) {
                    String pkStr = SynchroTableMetadata.toPkStr((Collection)sourceDao.getPk(dataToUpdate));
                    if (currentBatchSize == maxRootRowCount) {
                        result.add(currentBatch);
                        currentBatch = ArrayListMultimap.create();
                        currentBatchSize = 0;
                    }
                    currentBatch.put((Object)tableName, (Object)pkStr);
                    ++currentBatchSize;
                }
                Daos.closeSilently((ResultSet)dataToUpdate);
                dataToUpdate = null;
            }
            if (currentBatchSize > 0) {
                result.add(currentBatch);
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new SynchroTechnicalException((Throwable)e);
            }
            catch (Throwable throwable) {
                Daos.closeSilently(dataToUpdate);
                IOUtils.closeQuietly(sourceDaoFactory);
                this.closeSilently(dbMeta);
                this.closeSilently(sourceConnection);
                throw throwable;
            }
        }
        Daos.closeSilently(dataToUpdate);
        IOUtils.closeQuietly((Closeable)sourceDaoFactory);
        this.closeSilently(dbMeta);
        this.closeSilently(sourceConnection);
        return arrayList;
    }

    protected void addProgressionListeners(final ProgressionModel mainProgressionModel, ProgressionModel batchProgressionModel, final int batchProgressionModelOffset) {
        batchProgressionModel.addPropertyChangeListener("current", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer current = (Integer)evt.getNewValue();
                mainProgressionModel.setCurrent(batchProgressionModelOffset + current);
            }
        });
        batchProgressionModel.addPropertyChangeListener("message", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String message = (String)evt.getNewValue();
                mainProgressionModel.setMessage(message);
            }
        });
    }

    protected void commitAndCompact(SynchroDatabaseConfiguration dbConfig) throws SQLException {
        Connection connection = null;
        try {
            connection = this.createConnection(dbConfig);
            connection.commit();
            DaoUtils.compactDatabase((Connection)connection);
            System.gc();
        }
        finally {
            this.closeSilently(connection);
        }
    }

    protected void synchronizeUsingBatch(SynchroContext synchroContext, List<Multimap<String, String>> pkIncludesListForBatch) {
        boolean savedEnableDelete;
        DataSynchroContext dataSynchroContext = (DataSynchroContext)synchroContext;
        SynchroResult result = dataSynchroContext.getResult();
        boolean currentBatchEnableDelete = savedEnableDelete = dataSynchroContext.isEnableDelete();
        ProgressionModel progressionModel = result.getProgressionModel();
        progressionModel.setCurrent(0);
        progressionModel.setTotal(result.getTotalRows() + pkIncludesListForBatch.size());
        result.clear();
        for (Multimap<String, String> currentBatchPkIncludes : pkIncludesListForBatch) {
            SynchroResult currentBatchResult = new SynchroResult(result.getLocalUrl(), result.getRemoteUrl());
            for (String tableName : currentBatchPkIncludes.keySet()) {
                currentBatchResult.setUpdateDate(tableName, null);
                currentBatchResult.addRows(tableName, currentBatchPkIncludes.get((Object)tableName).size());
            }
            dataSynchroContext.setResult(currentBatchResult);
            dataSynchroContext.setPkIncludes(currentBatchPkIncludes);
            dataSynchroContext.setEnableDelete(currentBatchEnableDelete);
            int batchProgessionModelOffset = progressionModel.getCurrent();
            this.addProgressionListeners(progressionModel, currentBatchResult.getProgressionModel(), batchProgessionModelOffset);
            super.synchronize(synchroContext);
            result.addAll(currentBatchResult);
            if (!currentBatchResult.isSuccess()) {
                result.setError(currentBatchResult.getError());
                break;
            }
            currentBatchEnableDelete = false;
            try {
                this.commitAndCompact(synchroContext.getTarget());
            }
            catch (SQLException e) {
                result.setError((Exception)e);
                break;
            }
        }
        progressionModel.setCurrent(progressionModel.getTotal());
        dataSynchroContext.setResult(result);
        dataSynchroContext.setPkIncludes(null);
        dataSynchroContext.setEnableDelete(savedEnableDelete);
    }
}

