/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service.data;

import com.google.common.collect.Multimap;
import fr.ifremer.adagio.synchro.service.AbstractSynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.service.SynchroContext;
import java.util.Date;
import java.util.Set;

public class DataSynchroContext
extends AbstractSynchroContext {
    protected Date dataStartDate;
    protected Date dataEndDate;
    protected Multimap<String, String> pkIncludes;
    protected boolean forceEditedRowOverride = false;
    protected Set<String> programCodes;

    public DataSynchroContext() {
    }

    public DataSynchroContext(DataSynchroContext otherBean) {
        this.copy(otherBean);
    }

    public DataSynchroContext(SynchroDirection direction, Integer personId) {
        this.setDirection(direction);
        this.setPersonId(personId);
    }

    public DataSynchroContext(SynchroContext delegate, SynchroDirection direction, Integer personId) {
        super(delegate, direction, personId);
    }

    public DataSynchroContext(SynchroContext delegate, SynchroDirection direction, Integer personId, Integer personSessionId) {
        super(delegate, direction, personId);
        this.setPersonSessionId(personSessionId);
    }

    public Date getDataStartDate() {
        return this.dataStartDate;
    }

    public void setDataStartDate(Date dataStartDate) {
        this.dataStartDate = dataStartDate;
    }

    public Date getDataEndDate() {
        return this.dataEndDate;
    }

    public void setDataEndDate(Date dataEndDate) {
        this.dataEndDate = dataEndDate;
    }

    public void setPkIncludes(Multimap<String, String> pkIncludes) {
        this.pkIncludes = pkIncludes;
    }

    public Multimap<String, String> getPkIncludes() {
        return this.pkIncludes;
    }

    @Override
    public Set<String> getProgramCodes() {
        return this.programCodes;
    }

    @Override
    public void setProgramCodes(Set<String> programCodes) {
        this.programCodes = programCodes;
    }

    public boolean isForceEditedRowOverride() {
        return this.forceEditedRowOverride;
    }

    public void setForceEditedRowOverride(boolean forceEditedRowOverride) {
        this.forceEditedRowOverride = forceEditedRowOverride;
    }

    @Override
    public void copy(SynchroContext otherBean) {
        super.copy(otherBean);
        if (otherBean.getTarget() != null) {
            this.setTarget(new DataSynchroDatabaseConfiguration(this, otherBean.getTarget()));
        }
        if (otherBean.getSource() != null) {
            this.setSource(new DataSynchroDatabaseConfiguration(this, otherBean.getSource()));
        }
        if (otherBean instanceof DataSynchroContext) {
            this.dataStartDate = ((DataSynchroContext)otherBean).dataStartDate;
            this.dataEndDate = ((DataSynchroContext)otherBean).dataEndDate;
            this.pkIncludes = ((DataSynchroContext)otherBean).pkIncludes;
            this.programCodes = ((DataSynchroContext)otherBean).programCodes;
            this.forceEditedRowOverride = ((DataSynchroContext)otherBean).forceEditedRowOverride;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n  override edited row silently: ").append(this.forceEditedRowOverride);
        if (this.getDataStartDate() != null) {
            sb.append("\n  data start date: ").append(this.getDataStartDate());
            sb.append("\n         end date: ").append(this.getDataEndDate());
        }
        if (this.getProgramCodes() != null) {
            sb.append("\n     programs: ").append(this.getProgramCodes());
        }
        if (this.getPkIncludes() != null) {
            sb.append("\n  PK includes: ").append(this.getPkIncludes().toString());
        }
        return sb.toString();
    }
}

