/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.referential;

import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.synchro.intercept.referential.AbstractReferentialInterceptor;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class VesselTablesQueriesInterceptor
extends AbstractReferentialInterceptor {
    private static final Log log = LogFactory.getLog(VesselTablesQueriesInterceptor.class);
    public static final String COLUMN_PROGRAM_FK = "program_fk";
    public static final String COLUMN_VESSEL_FK = "vessel_fk";

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        String tableName = table.getName().toUpperCase();
        return "VESSEL".equals(tableName) || "VESSEL_FEATURES".equals(tableName) || "VESSEL_REGISTRATION_PERIOD".equals(tableName) || "VESSEL_OWNER_PERIOD".equals(tableName) || "VESSEL_OWNER".equals(tableName);
    }

    @Subscribe
    public void handleCreateQuery(CreateQueryEvent e) {
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                e.sql = this.addVesselRestriction(e.source, e.sql);
                break;
            }
        }
    }

    protected String addVesselRestriction(SynchroTableMetadata table, String sql) {
        boolean hasVesselColumn = this.hasColumns(table, new String[]{COLUMN_VESSEL_FK});
        boolean hasProgramColumn = this.hasColumns(table, new String[]{COLUMN_PROGRAM_FK});
        SynchroQueryBuilder query = SynchroQueryBuilder.newBuilder((String)sql);
        String programCode = AdagioConfiguration.getInstance().getVesselRegistryProgramCode();
        if (hasVesselColumn) {
            query.addJoin(" LEFT OUTER JOIN VESSEL v ON v.code=t.vessel_fk");
            query.addWhere(SynchroQueryOperator.AND, String.format("(v.code IS NULL OR v.%s='%s')", COLUMN_PROGRAM_FK, programCode));
        }
        if (!hasVesselColumn && hasProgramColumn) {
            query.addWhere(SynchroQueryOperator.AND, String.format(" t.%s='%s'", COLUMN_PROGRAM_FK, programCode));
        }
        String newSql = query.build();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Replace default SQL with: " + newSql));
        }
        return newSql;
    }
}

