/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.referential;

import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.synchro.intercept.referential.AbstractReferentialInterceptor;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class TranscribingItemInterceptor
extends AbstractReferentialInterceptor {
    public static final String COLUMN_TRANSCRIBING_ITEM_TYPE_FK = "transcribing_item_type_fk";

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return "TRANSCRIBING_ITEM".equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleCreateQuery(CreateQueryEvent e) {
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                String transcribingTypeIds = AdagioConfiguration.getInstance().getImportTranscribingItemTypeIds();
                if (StringUtils.isBlank((CharSequence)transcribingTypeIds)) {
                    transcribingTypeIds = "-1";
                }
                e.sql = SynchroQueryBuilder.newBuilder((String)e.sql).addWhere(SynchroQueryOperator.AND, String.format("%s in (%s)", COLUMN_TRANSCRIBING_ITEM_TYPE_FK, transcribingTypeIds)).build();
                break;
            }
        }
    }
}

