/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data.internal;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.SynchroTechnicalException;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroBaseDao;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.nuiton.i18n.I18n;

public class ImportRemoteIdInterceptor
extends SynchroInterceptorBase {
    private final String tableName;
    private final String columnName;
    private final int columnIndex;
    private final boolean isNullable;
    private final String selectIdFromRemoteIdQuery;
    private DataSynchroDatabaseConfiguration config;
    private PreparedStatement selectIdFromRemoteIdStatement = null;

    public ImportRemoteIdInterceptor(DataSynchroDatabaseConfiguration config, String tableName, String columnName, int columnIndex, boolean isNullable) {
        Preconditions.checkArgument((columnIndex >= 0 ? 1 : 0) != 0);
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnIndex = columnIndex;
        this.isNullable = isNullable;
        this.config = config;
        this.selectIdFromRemoteIdQuery = this.initSelectIdFromRemoteIdQuery(config, tableName);
        this.setEnableOnRead(true);
        this.setEnableOnWrite(true);
    }

    public SynchroInterceptorBase clone() {
        return new ImportRemoteIdInterceptor(this.config, this.tableName, this.columnName, this.columnIndex, this.isNullable);
    }

    protected void doOnWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer, boolean insert) throws SQLException {
        Integer remoteId = (Integer)data[this.columnIndex];
        if (remoteId == null) {
            return;
        }
        Integer localId = this.getIdFromRemoteId((SynchroBaseDao)targetDao, remoteId);
        if (localId == null) {
            if (!this.isNullable) {
                throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.synchronizeData.noIdFromRemoteId.error", (Object[])new Object[]{this.config.getColumnId(), this.tableName.toUpperCase(), this.config.getColumnRemoteId(), remoteId}));
            }
            buffer.addMissingColumnUpdate(this.columnName, pk, (Object)remoteId);
            data[this.columnIndex] = null;
        } else {
            data[this.columnIndex] = localId;
        }
    }

    protected void doOnRead(Object[] data, SynchroTableDao sourceDao, SynchroTableDao targetDao) throws SQLException {
        Integer remoteId = null;
        remoteId = data[this.columnIndex] instanceof String ? Integer.valueOf((String)data[this.columnIndex]) : (Integer)data[this.columnIndex];
        if (remoteId == null) {
            return;
        }
        Integer localId = this.getIdFromRemoteId((SynchroBaseDao)targetDao, remoteId);
        if (localId == null) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.synchronizeData.noIdFromRemoteId.error", (Object[])new Object[]{this.config.getColumnId(), this.tableName.toUpperCase(), this.config.getColumnRemoteId(), remoteId}));
        }
        data[this.columnIndex] = localId;
    }

    protected Integer getIdFromRemoteId(SynchroBaseDao dao, Integer remoteId) throws SQLException {
        Integer result = (Integer)dao.getUniqueTyped(this.selectIdFromRemoteIdQuery, new Object[]{remoteId});
        return result;
    }

    protected void doClose() throws IOException {
        super.doClose();
        Daos.closeSilently((Statement)this.selectIdFromRemoteIdStatement);
        this.selectIdFromRemoteIdStatement = null;
    }

    protected String initSelectIdFromRemoteIdQuery(DataSynchroDatabaseConfiguration config, String tableName) {
        return String.format("SELECT %s FROM %s where %s=?", config.getColumnId(), tableName, config.getColumnRemoteId());
    }

    public boolean equals(Object obj) {
        if (obj.getClass().isAssignableFrom(ImportRemoteIdInterceptor.class)) {
            ImportRemoteIdInterceptor importInterceptor = (ImportRemoteIdInterceptor)((Object)obj);
            if (importInterceptor.getTableName() == null || importInterceptor.getColumnName() == null || this.tableName == null || this.columnName == null) {
                return false;
            }
            if (importInterceptor.getTableName().equalsIgnoreCase(this.tableName) && importInterceptor.getColumnName().equalsIgnoreCase(this.columnName)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.tableName != null ? this.tableName.hashCode() : 0);
        hash = 67 * hash + (this.columnName != null ? this.columnName.hashCode() : 0);
        return hash;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

