/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroBaseDao;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroBadUpdateDateRowException;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import org.nuiton.i18n.I18n;

public class ImportEditedRowInterceptor
extends SynchroInterceptorBase {
    private final String tableName;
    private final int remoteIdColumnIndex;
    private final int updateDateColumnIndex;
    private final String selectLocalIdEditedRowQuery;
    private DataSynchroDatabaseConfiguration config;
    private PreparedStatement selectIdFromRemoteIdStatement = null;

    public ImportEditedRowInterceptor(DataSynchroDatabaseConfiguration config, String tableName, int remoteIdColumnIndex, int updateDateColumnIndex) {
        Preconditions.checkArgument((remoteIdColumnIndex >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((updateDateColumnIndex >= 0 ? 1 : 0) != 0);
        this.tableName = tableName;
        this.remoteIdColumnIndex = remoteIdColumnIndex;
        this.updateDateColumnIndex = updateDateColumnIndex;
        this.config = config;
        this.selectLocalIdEditedRowQuery = this.initSelectLocalIdEditedRowQuery(config, tableName);
        this.setEnableOnWrite(true);
    }

    public SynchroInterceptorBase clone() {
        return new ImportEditedRowInterceptor(this.config, this.tableName, this.remoteIdColumnIndex, this.updateDateColumnIndex);
    }

    protected void doOnWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer, boolean insert) throws SQLException {
        boolean canOverride;
        Integer remoteId = (Integer)data[this.remoteIdColumnIndex];
        if (remoteId == null) {
            return;
        }
        Integer editedLocalId = this.getLocalIdEditedRow((SynchroBaseDao)targetDao, remoteId);
        boolean bl = canOverride = editedLocalId == null;
        if (!canOverride) {
            Timestamp validUpdateDate = (Timestamp)data[this.updateDateColumnIndex];
            throw new SynchroBadUpdateDateRowException(I18n.t((String)"adagio.synchro.synchronizeData.editedRow.error", (Object[])new Object[]{this.tableName, editedLocalId}), this.tableName, (List)ImmutableList.of((Object)remoteId), (List)ImmutableList.of((Object)editedLocalId), validUpdateDate);
        }
    }

    protected Integer getLocalIdEditedRow(SynchroBaseDao dao, Integer remoteId) throws SQLException {
        Integer result = (Integer)dao.getUniqueTyped(this.selectLocalIdEditedRowQuery, new Object[]{remoteId});
        return result;
    }

    protected void doClose() throws IOException {
        super.doClose();
        Daos.closeSilently((Statement)this.selectIdFromRemoteIdStatement);
        this.selectIdFromRemoteIdStatement = null;
    }

    protected String initSelectLocalIdEditedRowQuery(DataSynchroDatabaseConfiguration config, String tableName) {
        return String.format("SELECT %s FROM %s where %s=? and %s <> '%s'", config.getColumnId(), tableName, config.getColumnRemoteId(), config.getColumnSynchronizationStatus(), SynchronizationStatus.SYNCHRONIZED.getValue());
    }
}

