/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroBaseDao;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroDeletedRowException;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.common.synchro.service.SynchroResult;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;

public class ExportPkRemoteIdInterceptor
extends SynchroInterceptorBase {
    public static final String COLUMN_SYNCHRONIZATION_STATUS = "synchronization_status";
    public static final String SYNCHRONIZATION_STATUS_SYNC = SynchronizationStatus.SYNCHRONIZED.getValue();
    private final String tableName;
    private final String columnName;
    private final int columnIndex;
    private final boolean hasChildJoins;
    private final String selectRemoteIdFromIdQuery;
    private final String updateRemoteIdByIdQuery;
    private final boolean withSynchronizationStatus;
    private final boolean withUpdateDate;
    private final int updateDateColumnIndex;
    private final Timestamp systimestamp;
    private final DataSynchroDatabaseConfiguration config;
    private PreparedStatement selectRemoteIdFromIdStatement = null;
    private PreparedStatement updateRemoteIdByIdStatement = null;

    public ExportPkRemoteIdInterceptor(DataSynchroDatabaseConfiguration config, String tableName, String columnName, int columnIndex, boolean withSynchronizationStatus, boolean withUpdateDate, int updateDateColumnIndex, Timestamp systimestamp, boolean hasChildJoins) {
        Preconditions.checkArgument((columnIndex >= 0 ? 1 : 0) != 0);
        this.tableName = tableName;
        this.config = config;
        this.columnName = columnName;
        this.columnIndex = columnIndex;
        this.hasChildJoins = hasChildJoins;
        this.withSynchronizationStatus = withSynchronizationStatus;
        this.withUpdateDate = withUpdateDate;
        this.updateDateColumnIndex = updateDateColumnIndex;
        this.systimestamp = systimestamp;
        this.selectRemoteIdFromIdQuery = this.initSelectRemoteIdFromIdQuery(config, tableName);
        this.updateRemoteIdByIdQuery = this.initUpdateRemoteIdByIdQuery(config, tableName);
        this.setEnableOnWrite(true);
        this.setEnableOnRead(true);
    }

    public SynchroInterceptorBase clone() {
        return new ExportPkRemoteIdInterceptor(this.config, this.tableName, this.columnName, this.columnIndex, this.withSynchronizationStatus, this.withUpdateDate, this.updateDateColumnIndex, this.systimestamp, this.hasChildJoins);
    }

    protected void doOnWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository operationContext, boolean insert) throws SQLException {
        if (data[this.columnIndex] == null) {
            return;
        }
        long localId = Long.parseLong(data[this.columnIndex].toString());
        SynchroResult result = operationContext.getSynchroContext().getResult();
        Number remoteId = this.getRemoteIdFromId((SynchroBaseDao)sourceDao, localId);
        if (remoteId == null) {
            remoteId = (Number)pk.get(0);
            result.addSourceMissingColumnUpdate(this.tableName, this.config.getColumnRemoteId(), (List)ImmutableList.of((Object)localId), (Object)remoteId);
            this.updateRemoteIdById((SynchroBaseDao)sourceDao, localId, remoteId);
        } else if (!remoteId.equals(pk.get(0)) && !remoteId.toString().equals(pk.get(0).toString())) {
            throw new SynchroDeletedRowException(this.tableName, String.valueOf(localId), remoteId.toString());
        }
        data[this.columnIndex] = remoteId;
        if (this.withSynchronizationStatus) {
            result.addSourceMissingColumnUpdate(this.tableName, COLUMN_SYNCHRONIZATION_STATUS, (List)ImmutableList.of((Object)localId), (Object)SYNCHRONIZATION_STATUS_SYNC);
        }
        if (this.withUpdateDate) {
            data[this.updateDateColumnIndex] = this.systimestamp;
            result.addSourceMissingColumnUpdate(this.tableName, this.config.getColumnUpdateDate(), (List)ImmutableList.of((Object)localId), (Object)this.systimestamp.toString());
        }
    }

    protected void doOnRead(Object[] data, SynchroTableDao sourceDao, SynchroTableDao targetDao) throws SQLException {
        if (data[this.columnIndex] == null) {
            return;
        }
        Long localId = Long.parseLong(data[this.columnIndex].toString());
        Number remoteId = this.getRemoteIdFromId((SynchroBaseDao)sourceDao, localId);
        data[this.columnIndex] = remoteId == null ? (Number)-1 : (Number)remoteId;
        if (this.withUpdateDate) {
            data[this.updateDateColumnIndex] = this.systimestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Number getRemoteIdFromId(SynchroBaseDao dao, long localId) throws SQLException {
        if (this.selectRemoteIdFromIdStatement == null || this.selectRemoteIdFromIdStatement.isClosed()) {
            this.selectRemoteIdFromIdStatement = dao.getPreparedStatement(this.selectRemoteIdFromIdQuery);
        }
        this.selectRemoteIdFromIdStatement.setLong(1, localId);
        ResultSet resultSet = null;
        try {
            resultSet = this.selectRemoteIdFromIdStatement.executeQuery();
            if (!resultSet.next()) {
                Number number = null;
                return number;
            }
            if (resultSet.getObject(1) == null) {
                Number number = null;
                return number;
            }
            Number number = (Number)resultSet.getObject(1);
            return number;
        }
        finally {
            Daos.closeSilently((ResultSet)resultSet);
        }
    }

    protected boolean updateRemoteIdById(SynchroBaseDao dao, long localId, Number remoteId) throws SQLException {
        if (this.updateRemoteIdByIdStatement == null || this.updateRemoteIdByIdStatement.isClosed()) {
            this.updateRemoteIdByIdStatement = dao.getPreparedStatement(this.updateRemoteIdByIdQuery);
        }
        this.updateRemoteIdByIdStatement.setObject(1, remoteId);
        this.updateRemoteIdByIdStatement.setLong(2, localId);
        return this.updateRemoteIdByIdStatement.execute();
    }

    protected void doClose() throws IOException {
        super.doClose();
        Daos.closeSilently((Statement)this.selectRemoteIdFromIdStatement);
        this.selectRemoteIdFromIdStatement = null;
        Daos.closeSilently((Statement)this.updateRemoteIdByIdStatement);
        this.updateRemoteIdByIdStatement = null;
    }

    protected String initSelectRemoteIdFromIdQuery(DataSynchroDatabaseConfiguration config, String tableName) {
        return String.format("SELECT %s FROM %s where %s=?", config.getColumnRemoteId(), tableName, config.getColumnId());
    }

    protected String initUpdateRemoteIdByIdQuery(DataSynchroDatabaseConfiguration config, String tableName) {
        return String.format("UPDATE %s set %s=? where %s=?", tableName, config.getColumnRemoteId(), config.getColumnId());
    }
}

