/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.ObjectTypeHelper;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryName;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class RootDataTableInterceptor
extends AbstractDataInterceptor {
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_VESSEL_FK = "vessel_fk";
    public static final String COLUMN_PROGRAM_FK = "program_fk";
    public static final String COLUMN_SYNCHRONIZATION_STATUS = "synchronization_status";

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        boolean isRootTable = this.isRootTable(table);
        return isRootTable;
    }

    @Subscribe
    public void handleQuery(CreateQueryEvent e) {
        SynchroDirection direction = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                if (direction == SynchroDirection.IMPORT_SERVER2TEMP) {
                    e.sql = this.addRestrictionOnImportServer2TempDb(e.source, e.queryName, e.sql);
                    e.sql = this.addDebugRestriction(e.sql);
                    break;
                }
                if (direction == SynchroDirection.IMPORT_TEMP2LOCAL) {
                    e.sql = this.addRestrictionOnImportTemp2LocalDb(e.source, e.queryName, e.sql);
                    break;
                }
                if (direction != SynchroDirection.EXPORT_LOCAL2TEMP) break;
                e.sql = this.addRestrictionOnExport(e.source, e.queryName, e.sql);
                e.sql = this.addDebugRestriction(e.sql);
                break;
            }
        }
    }

    protected String addRestrictionOnImportServer2TempDb(SynchroTableMetadata table, SynchroQueryName queryName, String sql) {
        String dateColumnName;
        String pkFilter;
        DataSynchroDatabaseConfiguration databaseConfiguration = (DataSynchroDatabaseConfiguration)((Object)this.getConfig());
        boolean enableUpdateDateFilter = SynchroQueryName.withUpdateDate((SynchroQueryName)queryName);
        Set<String> objectTypes = ObjectTypeHelper.getObjectTypeFromTableName(table.getName());
        Preconditions.checkNotNull((Object)CollectionUtils.isNotEmpty(objectTypes));
        String objectTypeList = "'" + Joiner.on((String)"','").join(objectTypes) + "'";
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((SynchroQueryName)queryName, (String)sql);
        int personSessionId = this.checkAndGetPersonSessionId();
        if (queryName == SynchroQueryName.count || queryName == SynchroQueryName.countFromUpdateDate) {
            queryBuilder.replaceColumn("count(*)", "count(distinct t.ID)");
        } else {
            queryBuilder.setColumnDistinct(true);
        }
        queryBuilder.addJoin("INNER JOIN PERSON_SESSION_VESSEL psv ON psv.vessel_fk=t.vessel_fk" + String.format(" AND psv.person_session_fk=%s", personSessionId) + " AND psv.program_fk=t.program_fk");
        if (enableUpdateDateFilter) {
            queryBuilder.addWhere(SynchroQueryOperator.OR, "psv.update_date", ">", ":updateDate");
        }
        queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("psv.object_type_fk IN (%s)", objectTypeList));
        String programFilter = this.createProgramCodesFilter("t.program_fk IN (%s)");
        if (StringUtils.isNotBlank((CharSequence)programFilter)) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, programFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)(pkFilter = this.createPkFilter(table.getName())))) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, pkFilter);
        } else if (databaseConfiguration.getDataStartDate() != null && databaseConfiguration.getDataEndDate() != null && (dateColumnName = this.getFirstExistingColumnName(table, "return_date_time", "sale_start_date", "landing_date_time", "end_date_time", "start_date_time")) != null) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("t.%s  >= :startDate AND t.%s <= :endDate", dateColumnName, dateColumnName));
        }
        return queryBuilder.build();
    }

    protected String addRestrictionOnImportTemp2LocalDb(SynchroTableMetadata table, SynchroQueryName queryName, String sql) {
        String pkFilter = this.createPkFilter(table.getName());
        if (StringUtils.isBlank((CharSequence)pkFilter)) {
            return sql;
        }
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((SynchroQueryName)queryName, (String)sql);
        queryBuilder.addWhere(SynchroQueryOperator.AND, pkFilter);
        return queryBuilder.build();
    }

    protected String addRestrictionOnExport(SynchroTableMetadata table, SynchroQueryName queryName, String sql) {
        Set<String> objectTypes = ObjectTypeHelper.getObjectTypeFromTableName(table.getName());
        Preconditions.checkNotNull((Object)CollectionUtils.isNotEmpty(objectTypes));
        String objectTypeList = "'" + Joiner.on((String)"','").join(objectTypes) + "'";
        SynchroQueryBuilder queryBuilder = SynchroQueryBuilder.newBuilder((SynchroQueryName)queryName, (String)sql);
        if (queryName == SynchroQueryName.count || queryName == SynchroQueryName.countFromUpdateDate) {
            queryBuilder.replaceColumn("count(*)", "count(distinct t.ID)");
        } else {
            queryBuilder.setColumnDistinct(true);
        }
        String pkFilter = this.createPkFilter(table.getName());
        if (StringUtils.isNotBlank((CharSequence)pkFilter)) {
            queryBuilder.addWhere(SynchroQueryOperator.AND, pkFilter);
            queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("%s='%s'", COLUMN_SYNCHRONIZATION_STATUS, SynchronizationStatus.READY_TO_SYNCHRONIZE.value()));
        } else {
            int personId = this.checkAndGetPersonId();
            queryBuilder.addJoin("INNER JOIN PERSON_SESSION_VESSEL psv ON psv.vessel_fk=t.vessel_fk AND psv.program_fk=t.program_fk INNER JOIN PERSON_SESSION ps ON ps.id=psv.person_session_fk AND ps.person_fk=" + personId);
            queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("%s='%s'", COLUMN_SYNCHRONIZATION_STATUS, SynchronizationStatus.READY_TO_SYNCHRONIZE.value()));
            queryBuilder.addWhere(SynchroQueryOperator.AND, String.format("psv.object_type_fk IN (%s)", objectTypeList));
            String programFilter = this.createProgramCodesFilter("t.program_fk IN (%s)");
            if (StringUtils.isNotBlank((CharSequence)programFilter)) {
                queryBuilder.addWhere(SynchroQueryOperator.AND, programFilter);
            }
        }
        return queryBuilder.build();
    }

    protected boolean isRootTable(TableMetadata table) {
        boolean hasRootColumns = this.hasColumns(table, new String[]{COLUMN_VESSEL_FK, COLUMN_PROGRAM_FK, ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnUpdateDate()});
        boolean hasObjectType = CollectionUtils.isNotEmpty(ObjectTypeHelper.getObjectTypeFromTableName(table.getName()));
        return hasRootColumns && hasObjectType;
    }

    protected String addDebugRestriction(String sql) {
        String vesselIncludesStr = AdagioConfiguration.getInstance().getApplicationConfig().getOption("adagio.synchro.import.vessels.includes");
        if (StringUtils.isBlank((CharSequence)vesselIncludesStr)) {
            return sql;
        }
        StringBuilder vesselsParam = new StringBuilder();
        for (String vesselCode : vesselIncludesStr.split(",")) {
            vesselsParam.append(",'").append(vesselCode).append("'");
        }
        return SynchroQueryBuilder.newBuilder((String)sql).addWhere(SynchroQueryOperator.AND, String.format("t.vessel_fk in (%s)", vesselsParam.substring(1))).build();
    }

    protected String createProgramCodesFilter(String stringToFormat) {
        String programCodes = AdagioConfiguration.getInstance().getImportProgramCodes();
        if (StringUtils.isBlank((CharSequence)programCodes)) {
            return null;
        }
        return String.format(stringToFormat, "'" + Joiner.on((String)"','").join(Splitter.on((char)',').split((CharSequence)programCodes)) + "'");
    }

    protected String createPkFilter(String tableName) {
        if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getPkIncludes() == null || ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getPkIncludes().isEmpty()) {
            return null;
        }
        Collection pkStrs = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getPkIncludes().get((Object)tableName.toUpperCase());
        if (CollectionUtils.isEmpty((Collection)pkStrs)) {
            return "1=2";
        }
        StringBuilder inBuilder = new StringBuilder();
        for (String pkStr : pkStrs) {
            inBuilder.append(',').append(pkStr);
        }
        return String.format("t.%s IN (%s)", COLUMN_ID, inBuilder.substring(1));
    }

    protected String getFirstExistingColumnName(SynchroTableMetadata table, String ... columnNames) {
        Set delegateColumns = table.getColumnNames();
        for (String columnName : columnNames) {
            if (!delegateColumns.contains(columnName.toLowerCase())) continue;
            return columnName;
        }
        return null;
    }
}

