/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.ObjectTypeHelper;
import fr.ifremer.adagio.synchro.meta.data.DataSynchroTables;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class DeletedItemHistoryInterceptor
extends AbstractDataInterceptor {
    private static String COLUMN_OBJECT_TYPE = "object_type_fk";
    private static String COLUMN_REMOTE_ID = "remote_id";
    private String whereClauseOnTableIncludes = null;
    private String whereClauseForExportLocal2Temp = null;

    public DeletedItemHistoryInterceptor() {
        super(DataSynchroTables.DELETED_ITEM_HISTORY.name(), SynchroDirection.IMPORT_SERVER2TEMP, SynchroDirection.EXPORT_LOCAL2TEMP, SynchroDirection.EXPORT_TEMP2SERVER);
    }

    @Override
    public SynchroInterceptorBase clone() {
        DeletedItemHistoryInterceptor newBean = (DeletedItemHistoryInterceptor)super.clone();
        newBean.whereClauseOnTableIncludes = this.whereClauseOnTableIncludes;
        newBean.whereClauseForExportLocal2Temp = this.whereClauseForExportLocal2Temp;
        return newBean;
    }

    @Subscribe
    public void handleCreateQuery(CreateQueryEvent e) {
        switch (e.queryName) {
            case count: 
            case countFromUpdateDate: 
            case select: 
            case selectFromUpdateDate: 
            case selectMaxUpdateDate: {
                e.sql = this.addRestrictions(e.sql);
                break;
            }
        }
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        boolean isRoot = this.isInDirections(SynchroDirection.IMPORT_SERVER2TEMP, SynchroDirection.EXPORT_LOCAL2TEMP, SynchroDirection.EXPORT_TEMP2SERVER);
        e.table.setRoot(isRoot);
    }

    private String addRestrictions(String sql) {
        SynchroQueryBuilder query = SynchroQueryBuilder.newBuilder((String)sql);
        if (this.whereClauseOnTableIncludes == null) {
            this.whereClauseOnTableIncludes = this.createWhereClauseOnTableIncludes();
        }
        query.addWhere(SynchroQueryOperator.AND, this.whereClauseOnTableIncludes);
        if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_LOCAL2TEMP) {
            if (this.whereClauseForExportLocal2Temp == null) {
                this.whereClauseForExportLocal2Temp = this.createWhereClauseForExportLocal2Temp();
            }
            query.addWhere(SynchroQueryOperator.AND, this.whereClauseForExportLocal2Temp);
        }
        return query.build();
    }

    private String createWhereClauseOnTableIncludes() {
        Set<String> tableToIncludes = DataSynchroTables.getImportTablesIncludes();
        if (CollectionUtils.isEmpty(tableToIncludes)) {
            return "1=2";
        }
        HashSet allObjectTypes = Sets.newHashSet();
        for (String tableName : tableToIncludes) {
            Set<String> objectTypes = ObjectTypeHelper.getObjectTypeFromTableName(tableName);
            if (CollectionUtils.isNotEmpty(objectTypes)) {
                allObjectTypes.addAll(objectTypes);
                continue;
            }
            allObjectTypes.add(tableName);
        }
        allObjectTypes.remove(DataSynchroTables.DELETED_ITEM_HISTORY.name());
        return COLUMN_OBJECT_TYPE + " IN ('" + Joiner.on((String)"','").join((Iterable)allObjectTypes) + "')";
    }

    private String createWhereClauseForExportLocal2Temp() {
        return COLUMN_REMOTE_ID + " is null";
    }
}

