/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.ObjectTypeHelper;
import fr.ifremer.adagio.synchro.intercept.data.internal.ExportFkRemoteIdInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.internal.ExportPkRemoteIdInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.internal.ImportEditedRowInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.internal.ImportRemoteIdInterceptor;
import fr.ifremer.adagio.synchro.meta.data.DataSynchroTables;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.intercept.SynchroInterceptor;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.common.synchro.meta.event.LoadJoinEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import fr.ifremer.common.synchro.query.SynchroQueryBuilder;
import fr.ifremer.common.synchro.query.SynchroQueryName;
import fr.ifremer.common.synchro.query.SynchroQueryOperator;
import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class DataTableInterceptor
extends AbstractDataInterceptor {
    private Set<String> dataTableIncludes = DataSynchroTables.getImportTablesIncludes();
    private Timestamp systimestamp = null;

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        if (CollectionUtils.isEmpty(this.dataTableIncludes)) {
            return false;
        }
        boolean isDataTable = this.dataTableIncludes.contains(table.getName());
        return isDataTable && this.hasColumns(table, new String[]{((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId(), ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId()});
    }

    @Override
    public SynchroInterceptorBase clone() {
        DataTableInterceptor result = (DataTableInterceptor)super.clone();
        result.dataTableIncludes = this.dataTableIncludes;
        result.systimestamp = this.systimestamp;
        return result;
    }

    @Subscribe
    public void handleQuery(CreateQueryEvent e) {
        SynchroDirection direction = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        if (direction == SynchroDirection.IMPORT_SERVER2TEMP) {
            switch (e.queryName) {
                case select: 
                case selectFromUpdateDate: {
                    e.sql = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId()).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus()).build();
                    break;
                }
                case insert: 
                case update: {
                    SynchroQueryBuilder qb = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId());
                    if (qb.constainsColumn(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus())) {
                        qb.setColumnValue(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus(), "'SYNC'");
                    }
                    e.sql = qb.build();
                    break;
                }
            }
        } else if (direction == SynchroDirection.IMPORT_TEMP2LOCAL) {
            switch (e.queryName) {
                case select: 
                case selectFromUpdateDate: {
                    e.sql = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId()).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus()).build();
                    break;
                }
                case insert: {
                    SynchroQueryBuilder qb = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumn(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId()).replaceColumn(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId(), ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId());
                    if (qb.constainsColumn(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus())) {
                        qb.setColumnValue(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus(), "'SYNC'");
                    }
                    qb.addColumn(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId(), e.source.getSelectSequenceNextValString());
                    e.sql = qb.build();
                    break;
                }
                case update: {
                    SynchroQueryBuilder qb = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumn(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId()).replaceColumn(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId(), ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId());
                    if (qb.constainsColumn(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus())) {
                        qb.setColumnValue(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus(), "'SYNC'");
                    }
                    e.sql = qb.build();
                    break;
                }
            }
        } else if (direction != SynchroDirection.EXPORT_LOCAL2TEMP && direction == SynchroDirection.EXPORT_TEMP2SERVER) {
            switch (e.queryName) {
                case selectMaxUpdateDate: {
                    e.sql = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).addWhere(SynchroQueryOperator.AND, "1=2").build();
                    break;
                }
                case select: 
                case selectFromUpdateDate: {
                    e.sql = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus()).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId()).build();
                    break;
                }
                case insert: {
                    SynchroQueryBuilder qb = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus()).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId());
                    e.sql = qb.build();
                    break;
                }
                case update: {
                    SynchroQueryBuilder qb = SynchroQueryBuilder.newBuilder((SynchroQueryName)e.queryName, (String)e.sql).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus()).deleteColumnIfExists(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId());
                    e.sql = qb.build();
                    break;
                }
            }
        }
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        boolean hasRemoteIdColumn;
        SynchroTableMetadata table = e.table;
        String remoteIdColumn = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId();
        String idColumn = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId();
        String updateDateColumn = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnUpdateDate();
        boolean hasSynchronizationStatusColumn = table.getColumnIndex(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnSynchronizationStatus()) != -1;
        boolean hasUpdateDateColumn = table.getColumnIndex(updateDateColumn) != -1;
        boolean hasObjectType = ObjectTypeHelper.getObjectTypeFromTableName(table.getName()) != null;
        boolean bl = hasRemoteIdColumn = table.getColumnIndex(remoteIdColumn) != -1;
        if (table.isRoot() || !hasSynchronizationStatusColumn || hasObjectType) {
            // empty if block
        }
        SynchroDirection direction = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        if (hasRemoteIdColumn && direction == SynchroDirection.IMPORT_TEMP2LOCAL) {
            if (!table.hasUniqueConstraint(remoteIdColumn)) {
                table.addUniqueConstraint(remoteIdColumn, (List)ImmutableList.of((Object)remoteIdColumn), SynchroTableMetadata.DuplicateKeyStrategy.REPLACE);
            }
            if (!((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).isForceEditedRowOverride() && hasSynchronizationStatusColumn && hasUpdateDateColumn) {
                ImportEditedRowInterceptor synchronizationStatusInterceptor = new ImportEditedRowInterceptor((DataSynchroDatabaseConfiguration)((Object)this.getConfig()), table.getName().toLowerCase(), table.getSelectColumnIndex(idColumn), table.getSelectColumnIndex(updateDateColumn));
                table.addInterceptor((SynchroInterceptor)synchronizationStatusInterceptor);
            }
        } else if (hasRemoteIdColumn && direction == SynchroDirection.EXPORT_TEMP2SERVER) {
            int updateDateColumnIndex;
            if (this.systimestamp == null) {
                this.systimestamp = this.checkAndGetSystemTimestamp((SynchroDatabaseConfiguration)this.getConfig());
            }
            if (!table.hasUniqueConstraint(remoteIdColumn)) {
                table.addUniqueConstraint(remoteIdColumn, (List)ImmutableList.of((Object)idColumn), SynchroTableMetadata.DuplicateKeyStrategy.REPLACE);
            }
            boolean hasUpdateDate = (updateDateColumnIndex = table.getSelectColumnIndex(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnUpdateDate())) != -1;
            ExportPkRemoteIdInterceptor remoteIdInterceptor = new ExportPkRemoteIdInterceptor((DataSynchroDatabaseConfiguration)((Object)this.getConfig()), table.getName(), idColumn, table.getSelectColumnIndex(idColumn), hasSynchronizationStatusColumn, hasUpdateDate, updateDateColumnIndex, this.systimestamp, table.hasChildJoins());
            table.addInterceptor((SynchroInterceptor)remoteIdInterceptor);
        }
    }

    @Subscribe
    public void handleJoinLoad(LoadJoinEvent e) {
        SynchroJoinMetadata join = e.join;
        if (!join.isValid()) {
            return;
        }
        SynchroTableMetadata fkTable = join.getFkTable();
        SynchroDirection direction = ((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection();
        if (fkTable == e.source || this.isNotInterceptedTable(fkTable)) {
            if (direction == SynchroDirection.IMPORT_TEMP2LOCAL) {
                SynchroTableMetadata pkTable = join.getPkTable();
                String pkTableName = pkTable.getName().toLowerCase();
                String fkColumnName = join.getFkColumn().getName().toLowerCase();
                int fkColumnIndex = fkTable.getSelectColumnIndex(fkColumnName);
                ImportRemoteIdInterceptor remoteIdInterceptor = new ImportRemoteIdInterceptor((DataSynchroDatabaseConfiguration)((Object)this.getConfig()), pkTableName, fkColumnName, fkColumnIndex, join.getFkColumn().isNullable());
                if (!fkTable.containsInterceptor((SynchroInterceptor)remoteIdInterceptor)) {
                    fkTable.addInterceptor((SynchroInterceptor)remoteIdInterceptor);
                }
            } else if (direction == SynchroDirection.EXPORT_TEMP2SERVER) {
                SynchroTableMetadata pkTable = join.getPkTable();
                String pkTableName = pkTable.getName().toLowerCase();
                String fkColumnName = join.getFkColumn().getName().toLowerCase();
                int fkColumnIndex = fkTable.getSelectColumnIndex(fkColumnName);
                ExportFkRemoteIdInterceptor remoteIdInterceptor = new ExportFkRemoteIdInterceptor((DataSynchroDatabaseConfiguration)((Object)this.getConfig()), pkTableName, fkColumnName, fkColumnIndex, join.getFkColumn().isNullable());
                if (!fkTable.containsInterceptor((SynchroInterceptor)remoteIdInterceptor)) {
                    fkTable.addInterceptor((SynchroInterceptor)remoteIdInterceptor);
                }
            }
        }
    }

    protected boolean isNotInterceptedTable(SynchroTableMetadata table) {
        Set columnNames = table.getColumnNames();
        return !columnNames.contains(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnId()) || !columnNames.contains(((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getColumnRemoteId());
    }

    protected Timestamp checkAndGetSystemTimestamp(SynchroDatabaseConfiguration configuration) {
        Timestamp systimestamp = configuration.getSystemTimestamp();
        Preconditions.checkNotNull((Object)systimestamp, (Object)String.format("Could not found system timestamp in database configuration. This is need for %s", ((Object)((Object)this)).getClass().getSimpleName()));
        return systimestamp;
    }
}

