/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept.data;

import com.google.common.eventbus.Subscribe;
import fr.ifremer.adagio.synchro.intercept.data.AbstractDataInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.internal.ExportFkRemoteIdInterceptor;
import fr.ifremer.adagio.synchro.intercept.data.internal.ImportRemoteIdInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.adagio.synchro.service.data.DataSynchroDatabaseConfiguration;
import fr.ifremer.common.synchro.dao.Daos;
import fr.ifremer.common.synchro.dao.SynchroBaseDao;
import fr.ifremer.common.synchro.dao.SynchroTableDao;
import fr.ifremer.common.synchro.intercept.SynchroInterceptor;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.intercept.SynchroOperationRepository;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.meta.SynchroTableMetadata;
import fr.ifremer.common.synchro.meta.event.LoadJoinEvent;
import fr.ifremer.common.synchro.meta.event.LoadTableEvent;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class BatchInterceptor
extends AbstractDataInterceptor {
    private int rootBatchFkColumnIndex = -1;
    private int parentBatchFkColumnIndex = -1;
    private int batchIdColumnIndex = -1;
    private boolean enableIntegrityConstraints = true;
    private static final String TABLE_BATCH = "BATCH";
    private static final String TABLE_OPERATION = "OPERATION";
    private static final String TABLE_QUANTIFICATION_MEASUREMENT = "QUANTIFICATION_MEASUREMENT";
    private static final String TABLE_SORTING_MEASUREMENT = "SORTING_MEASUREMENT";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_ROOT_BATCH = "root_batch_fk";
    public static final String COLUMN_PARENT_BATCH = "parent_batch_fk";
    public static final String COLUMN_OPERATION_CATCH_BATCH_FK = "catch_batch_fk";
    public static final String COLUMN_QM_BATCH_FK = "batch_fk";
    public static final String COLUMN_SM_BATCH_FK = "sorting_batch_fk";
    private PreparedStatement updateOperationCatchBatchFkStatement = null;
    private PreparedStatement deleteChildrenBatchesByRootBatchFkStatement = null;
    private PreparedStatement updateParentBatchFkStatement = null;
    private PreparedStatement deleteQuantificationMeasurementByBatchFkStatement = null;
    private PreparedStatement deleteSortingMeasurementByBatchFkStatement = null;

    public BatchInterceptor() {
        this.setEnableOnWrite(true);
    }

    @Override
    public void init(DataSynchroDatabaseConfiguration config) {
        super.init(config);
        this.enableIntegrityConstraints = config.getDirection() == SynchroDirection.EXPORT_TEMP2SERVER || config.getDirection() == SynchroDirection.IMPORT_TEMP2LOCAL;
    }

    @Override
    public SynchroInterceptorBase clone() {
        BatchInterceptor newBean = (BatchInterceptor)super.clone();
        newBean.batchIdColumnIndex = this.batchIdColumnIndex;
        newBean.rootBatchFkColumnIndex = this.rootBatchFkColumnIndex;
        newBean.parentBatchFkColumnIndex = this.parentBatchFkColumnIndex;
        newBean.enableIntegrityConstraints = this.enableIntegrityConstraints;
        return newBean;
    }

    @Override
    public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
        return TABLE_BATCH.equalsIgnoreCase(table.getName());
    }

    @Subscribe
    public void handleTableLoad(LoadTableEvent e) {
        e.table.setRoot(false);
        this.batchIdColumnIndex = e.table.getSelectColumnIndex(COLUMN_ID);
        this.rootBatchFkColumnIndex = e.table.getSelectColumnIndex(COLUMN_ROOT_BATCH);
        this.parentBatchFkColumnIndex = e.table.getSelectColumnIndex(COLUMN_PARENT_BATCH);
    }

    @Subscribe
    public void handleJoinLoad(LoadJoinEvent e) {
        boolean isJoinToRootOrParentTable;
        if (!e.join.isValid()) {
            return;
        }
        if (TABLE_OPERATION.equalsIgnoreCase(e.join.getTargetTable().getName())) {
            e.join.setIsValid(false);
        }
        String targetTableName = e.join.getTargetTable().getName();
        String targetColumnName = e.join.getTargetColumn().getName();
        boolean bl = isJoinToRootOrParentTable = TABLE_BATCH.equalsIgnoreCase(targetTableName) && (COLUMN_ROOT_BATCH.equalsIgnoreCase(targetColumnName) || COLUMN_PARENT_BATCH.equalsIgnoreCase(targetColumnName));
        if (isJoinToRootOrParentTable) {
            SynchroInterceptorBase batchRemoteIdInterceptor;
            SynchroTableMetadata batchTable;
            e.join.setIsValid(false);
            if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.EXPORT_TEMP2SERVER && !(batchTable = e.join.getFkTable()).containsInterceptor((SynchroInterceptor)(batchRemoteIdInterceptor = new ExportFkRemoteIdInterceptor((DataSynchroDatabaseConfiguration)((Object)this.getConfig()), TABLE_BATCH.toLowerCase(), targetColumnName.toLowerCase(), batchTable.getSelectColumnIndex(targetColumnName), e.join.getFkColumn().isNullable())))) {
                batchTable.addInterceptor((SynchroInterceptor)batchRemoteIdInterceptor);
            }
            if (((DataSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection() == SynchroDirection.IMPORT_TEMP2LOCAL && !(batchTable = e.join.getPkTable()).containsInterceptor((SynchroInterceptor)(batchRemoteIdInterceptor = new ImportRemoteIdInterceptor((DataSynchroDatabaseConfiguration)((Object)this.getConfig()), TABLE_BATCH.toLowerCase(), targetColumnName.toLowerCase(), batchTable.getSelectColumnIndex(targetColumnName), e.join.getFkColumn().isNullable())))) {
                batchTable.addInterceptor((SynchroInterceptor)batchRemoteIdInterceptor);
            }
        }
    }

    protected void doOnWrite(Object[] data, List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer, boolean insert) throws SQLException {
        Object parentBatchFk;
        if (buffer == null) {
            return;
        }
        Object rootBatchFk = data[this.rootBatchFkColumnIndex];
        if (rootBatchFk == null) {
            Object rootBatchId = data[this.batchIdColumnIndex];
            buffer.addChildToUpdateFromOneColumn(TABLE_BATCH, COLUMN_ROOT_BATCH, rootBatchId);
        }
        if ((parentBatchFk = data[this.parentBatchFkColumnIndex]) != null && this.enableIntegrityConstraints) {
            data[this.parentBatchFkColumnIndex] = null;
            buffer.addMissingColumnUpdate(COLUMN_PARENT_BATCH, pk, parentBatchFk);
        }
    }

    protected void doOnDelete(List<Object> pk, SynchroTableDao sourceDao, SynchroTableDao targetDao, SynchroOperationRepository buffer) throws SQLException {
        int localId = Integer.parseInt(pk.get(0).toString());
        this.deleteChildrenBatchesByRootBatch((SynchroBaseDao)targetDao, localId);
    }

    protected void doClose() throws IOException {
        super.doClose();
        Daos.closeSilently((Statement)this.updateOperationCatchBatchFkStatement);
        Daos.closeSilently((Statement)this.deleteChildrenBatchesByRootBatchFkStatement);
        this.updateOperationCatchBatchFkStatement = null;
        this.deleteChildrenBatchesByRootBatchFkStatement = null;
    }

    protected void deleteChildrenBatchesByRootBatch(SynchroBaseDao targetDao, int rootBatchId) throws SQLException {
        this.removeLinkToOperation(targetDao, rootBatchId);
        this.removeLinkToParentBatchByRootBatch(targetDao, rootBatchId);
        this.deleteQuantificationMeasurementByRootBatch(targetDao, rootBatchId);
        this.deleteSortingMeasurementByRootBatch(targetDao, rootBatchId);
        if (this.deleteChildrenBatchesByRootBatchFkStatement == null || this.deleteChildrenBatchesByRootBatchFkStatement.isClosed()) {
            this.deleteChildrenBatchesByRootBatchFkStatement = targetDao.getPreparedStatement(this.getDeleteBatchByRootBatchFkQuery());
        }
        this.deleteChildrenBatchesByRootBatchFkStatement.setInt(1, rootBatchId);
        this.deleteChildrenBatchesByRootBatchFkStatement.executeUpdate();
    }

    protected void removeLinkToOperation(SynchroBaseDao targetDao, int catchBatchId) throws SQLException {
        if (this.updateOperationCatchBatchFkStatement == null || this.updateOperationCatchBatchFkStatement.isClosed()) {
            this.updateOperationCatchBatchFkStatement = targetDao.getPreparedStatement(this.getUpdateOperationCatchBatchFkQuery());
        }
        this.updateOperationCatchBatchFkStatement.setInt(1, catchBatchId);
        this.updateOperationCatchBatchFkStatement.executeUpdate();
    }

    protected void removeLinkToParentBatchByRootBatch(SynchroBaseDao targetDao, int catchBatchId) throws SQLException {
        if (this.updateParentBatchFkStatement == null || this.updateParentBatchFkStatement.isClosed()) {
            this.updateParentBatchFkStatement = targetDao.getPreparedStatement(this.getUpdateParentBatchFkQuery());
        }
        this.updateParentBatchFkStatement.setInt(1, catchBatchId);
        this.updateParentBatchFkStatement.executeUpdate();
    }

    protected void deleteQuantificationMeasurementByRootBatch(SynchroBaseDao targetDao, int catchBatchId) throws SQLException {
        if (this.deleteQuantificationMeasurementByBatchFkStatement == null || this.deleteQuantificationMeasurementByBatchFkStatement.isClosed()) {
            this.deleteQuantificationMeasurementByBatchFkStatement = targetDao.getPreparedStatement(this.getDeleteQuantificationMeasurementByBatchFkQuery());
        }
        this.deleteQuantificationMeasurementByBatchFkStatement.setInt(1, catchBatchId);
        this.deleteQuantificationMeasurementByBatchFkStatement.setInt(2, catchBatchId);
        this.deleteQuantificationMeasurementByBatchFkStatement.executeUpdate();
    }

    protected void deleteSortingMeasurementByRootBatch(SynchroBaseDao targetDao, int catchBatchId) throws SQLException {
        if (this.deleteSortingMeasurementByBatchFkStatement == null || this.deleteSortingMeasurementByBatchFkStatement.isClosed()) {
            this.deleteSortingMeasurementByBatchFkStatement = targetDao.getPreparedStatement(this.getDeleteSortingMeasurementByBatchFkQuery());
        }
        this.deleteSortingMeasurementByBatchFkStatement.setInt(1, catchBatchId);
        this.deleteSortingMeasurementByBatchFkStatement.executeUpdate();
    }

    protected String getUpdateOperationCatchBatchFkQuery() {
        return String.format("UPDATE %s SET %s = null WHERE %s = ?", TABLE_OPERATION, COLUMN_OPERATION_CATCH_BATCH_FK, COLUMN_OPERATION_CATCH_BATCH_FK);
    }

    protected String getUpdateParentBatchFkQuery() {
        return String.format("UPDATE %s SET %s = null WHERE %s = ?", TABLE_BATCH, COLUMN_PARENT_BATCH, COLUMN_ROOT_BATCH);
    }

    protected String getDeleteQuantificationMeasurementByBatchFkQuery() {
        return String.format("DELETE FROM %s WHERE %s IN (SELECT %s FROM %s WHERE %s = ? OR %s = ?)", TABLE_QUANTIFICATION_MEASUREMENT, COLUMN_QM_BATCH_FK, COLUMN_ID, TABLE_BATCH, COLUMN_ID, COLUMN_ROOT_BATCH);
    }

    protected String getDeleteSortingMeasurementByBatchFkQuery() {
        return String.format("DELETE FROM %s WHERE %s IN (SELECT %s FROM %s WHERE %s = ?)", TABLE_SORTING_MEASUREMENT, COLUMN_SM_BATCH_FK, COLUMN_ID, TABLE_BATCH, COLUMN_ROOT_BATCH);
    }

    protected String getDeleteBatchByRootBatchFkQuery() {
        return String.format("DELETE FROM %s WHERE %s = ?", TABLE_BATCH, COLUMN_ROOT_BATCH);
    }
}

