/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.service.AbstractSynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.service.SynchroDirection;
import fr.ifremer.common.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.common.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.common.synchro.service.SynchroDatabaseConfiguration;
import java.util.Arrays;
import java.util.Set;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public abstract class AbstractSynchroInterceptor<T extends AbstractSynchroDatabaseConfiguration>
extends SynchroInterceptorBase {
    private SynchroDatabaseMetadata meta;
    private Set<SynchroDirection> allowDirections = Sets.newHashSet();
    private Set<String> allowTables;

    public AbstractSynchroInterceptor() {
        this.allowDirections = null;
        this.allowTables = null;
    }

    public AbstractSynchroInterceptor(SynchroDirection ... directions) {
        Preconditions.checkArgument((directions != null && directions.length > 0 ? 1 : 0) != 0);
        this.allowDirections = ImmutableSet.copyOf((Object[])directions);
        this.allowTables = null;
    }

    public AbstractSynchroInterceptor(Set<String> tableIncludes, SynchroDirection ... directions) {
        Preconditions.checkArgument((tableIncludes != null && tableIncludes.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((directions != null && directions.length > 0 ? 1 : 0) != 0);
        this.allowTables = ImmutableSet.copyOf(tableIncludes);
        this.allowDirections = ImmutableSet.copyOf((Object[])directions);
    }

    public AbstractSynchroInterceptor(Set<String> tableIncludes) {
        Preconditions.checkArgument((tableIncludes != null && tableIncludes.size() > 0 ? 1 : 0) != 0);
        this.allowTables = ImmutableSet.copyOf(tableIncludes);
        this.allowDirections = null;
    }

    public SynchroInterceptorBase clone() {
        AbstractSynchroInterceptor result = (AbstractSynchroInterceptor)super.clone();
        result.meta = this.meta;
        result.allowDirections = this.allowDirections;
        result.allowTables = this.allowTables;
        return result;
    }

    public final boolean apply(SynchroDatabaseConfiguration config) {
        boolean result;
        boolean bl = result = this.getConfigClass().isInstance(config) && super.apply(config);
        if (result) {
            this.init((AbstractSynchroDatabaseConfiguration)config);
        }
        return result;
    }

    protected abstract Class<T> getConfigClass();

    public final boolean apply(SynchroDatabaseMetadata meta, TableMetadata table) {
        Preconditions.checkNotNull((Object)meta);
        if (this.meta != null) {
            Preconditions.checkState((this.meta == meta ? 1 : 0) != 0);
        } else {
            this.meta = meta;
        }
        return !(this.allowDirections != null && !this.allowDirections.contains((Object)((AbstractSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection()) || this.allowTables != null && !this.allowTables.contains(table.getName()) || !this.doApply(meta, table));
    }

    public abstract boolean doApply(SynchroDatabaseMetadata var1, TableMetadata var2);

    public T getConfig() {
        return (T)((Object)((AbstractSynchroDatabaseConfiguration)this.getDefaultDatabaseConfiguration()));
    }

    protected void init(T config) {
    }

    protected int checkAndGetPersonId() {
        int personId = ((AbstractSynchroDatabaseConfiguration)((Object)this.getConfig())).getPersonId();
        Preconditions.checkNotNull((Object)personId, (Object)String.format("Could not retrieve person id (in database configuration). %s need a not null personId.", ((Object)((Object)this)).getClass().getSimpleName()));
        return personId;
    }

    protected int checkAndGetPersonSessionId() {
        int personSessionId = ((AbstractSynchroDatabaseConfiguration)((Object)this.getConfig())).getPersonSessionId();
        Preconditions.checkNotNull((Object)personSessionId, (Object)String.format("Could not retrieve person session (no personSessionId in context). %s need a not null personSessionId.", ((Object)((Object)this)).getClass().getSimpleName()));
        return personSessionId;
    }

    protected boolean isInDirections(SynchroDirection ... allowDirections) {
        return Arrays.asList(allowDirections).contains((Object)((AbstractSynchroDatabaseConfiguration)((Object)this.getConfig())).getDirection());
    }
}

