/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.dao.administration.user;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.dao.technical.jdbc.OptionalDatasourceJdbcDaoSupport;
import fr.ifremer.adagio.synchro.dao.administration.user.PersonSessionSynchroJdbcDao;
import fr.ifremer.common.synchro.dao.Daos;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository(value="personSessionSynchroJdbcDao")
@Lazy
public class PersonSessionSynchroJdbcDaoImpl
extends OptionalDatasourceJdbcDaoSupport
implements PersonSessionSynchroJdbcDao,
InitializingBean {
    private final int ORACLE_TYPE_CURSOR = -10;
    @Resource(name="synchroQueriesJdbcProperties")
    protected Properties queriesJdbcProperties;

    @Autowired
    public PersonSessionSynchroJdbcDaoImpl(DataSource dataSource) {
        super(dataSource);
    }

    public PersonSessionSynchroJdbcDaoImpl() {
        this.queriesJdbcProperties = this.loadPropertiesFromXml("synchro-queries.jdbc.xml");
        this.checkAllQueries();
    }

    public void afterPropertiesSet() throws Exception {
        this.checkAllQueries();
    }

    private void checkAllQueries() {
        this.checkQueryExists("personSessionIdByPerson");
        this.checkQueryExists("initPersonSessionCall");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int initPersonSession(Properties connectionProperties, int userId) {
        Connection connection;
        Preconditions.checkArgument((connectionProperties == null || Daos.isOracleDatabase((String)Daos.getUrl((Properties)connectionProperties)) ? 1 : 0) != 0, (Object)"Not implemented yet for non-Oracle database connection.");
        try {
            connection = this.createConnection(connectionProperties);
        }
        catch (SQLException e) {
            throw new AdagioTechnicalException("Could not connect to given database", (Throwable)e);
        }
        try {
            int n = this.initPersonSession(connection, userId);
            return n;
        }
        finally {
            this.closeSilently(connection);
        }
    }

    @Override
    public int getPersonSessionIdByPerson(Properties connectionProperties, int personId) {
        Preconditions.checkArgument((boolean)Daos.isOracleDatabase((String)Daos.getUrl((Properties)connectionProperties)), (Object)"Not implemented yet for non-Oracle database connection.");
        String sql = this.queriesJdbcProperties.getProperty("personSessionIdByPerson");
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("personId", personId);
        return (Integer)this.query(connectionProperties, sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                return rs.getInt(1);
            }
        });
    }

    protected int initPersonSession(Connection connection, int userId) {
        String sql = this.queriesJdbcProperties.getProperty("initPersonSessionCall");
        CallableStatement statement = null;
        try {
            statement = connection.prepareCall(sql);
            statement.registerOutParameter(1, -10);
            statement.setLong(2, (long)userId);
            statement.execute();
            ResultSet rs = (ResultSet)statement.getObject(1);
            rs.next();
            int personSessionId = rs.getInt(1);
            if (personSessionId == 0) {
                throw new DataRetrievalFailureException(String.format("Could not compute PERSON_SESSION for user with id=%s. Make sure this user exists in table PERSON.", userId));
            }
            int n = personSessionId;
            return n;
        }
        catch (SQLException e) {
            throw new AdagioTechnicalException("Error while executing function F_FILL_PERSON_SESSION.", (Throwable)e);
        }
        finally {
            Daos.closeSilently((Statement)statement);
        }
    }

    protected void checkQueryExists(String queryName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.queriesJdbcProperties.getProperty(queryName)), (Object)String.format("Property with name [%s] not exists on synchro JDBC queries file", queryName));
    }
}

