package fr.ifremer.adagio.synchro.intercept;

import java.util.List;
import java.util.Map;
import java.util.Set;

import fr.ifremer.adagio.synchro.service.SynchroContext;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

public interface SynchroOperationRepository {

	void addMissingColumnUpdate(String columnName, List<Object> pk, Object columnValue);

	void addMissingColumnUpdate(String columnName, String pkStr, Object columnValue);

	void addAllMissingColumnUpdates(Map<String, Map<String, Object>> missingUpdates);

	void addChildToUpdateFromOneColumn(String childTablename, String columnName, Object columnValue);

	void addChildrenToUpdateFromOneColumn(String childTablename, String columnName, List<Object> columnValues);

	void addChildToUpdateFromManyColumns(String childTablename, Set<String> columnNames, List<Object> columnValues);

	void addChildrenToUpdateFromManyColumns(String childTablename, Set<String> columnNames, List<List<Object>> columnValues);

	void addChildToDeleteFromManyColumns(String childTablename, Set<String> columnNames, List<Object> columnValue);

	void addChildToDeleteFromOneColumn(String childTablename, String columnName, Object columnValue);

	void addChildrenToDeleteFromOneColumn(String childTablename, String columnName, List<Object> columnValue);

	void addChildrenToDeleteFromManyColumns(String childTablename, Set<String> columnNames, List<List<Object>> columnValues);

	void addChildToDetachFromOneColumn(String childTablename, String columnName, Object columnValue);

	void addChildToDetachFromManyColumn(String childTablename, Set<String> columnNames, List<Object> columnValue);

	void addChildrenToDetachFromManyColumns(String childTablename, Set<String> columnNames, List<List<Object>> columnValues);

	void addAllMissingDelete(List<List<Object>> pk);

	void addMissingDelete(List<Object> pk);

	void addMissingDelete(String pkStr);

	void addAllMissingDetach(List<List<Object>> pks);

	void addMissingDetach(List<Object> pk);

	void addMissingDetach(String pkStr);

	/**
	 * Give a access to the context of the current synchronization
	 * 
	 * @return the result bean
	 */
	SynchroContext getSynchroContext();

}
