package fr.ifremer.adagio.synchro.dao;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Set;

import org.springframework.dao.DataIntegrityViolationException;

public class DataIntegrityViolationOnDeleteException extends DataIntegrityViolationException {

	private static final long serialVersionUID = -3347826640266779734L;

	private final String tableName;
	private final String pkStr;
	private final Set<String> existingFkTableNames;

	public DataIntegrityViolationOnDeleteException(String msg, String tableName, String pkStr, Set<String> existingFkTableNames) {
		super(msg);
		this.tableName = tableName;
		this.pkStr = pkStr;
		this.existingFkTableNames = existingFkTableNames;
	}

	public String getTableName() {
		return tableName;
	}

	public String getPkStr() {
		return pkStr;
	}

	public Set<String> getExistingFkTableNames() {
		return existingFkTableNames;
	}
}
