package fr.ifremer.adagio.synchro.socket;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;

public class SynchroHttpHandler implements HttpRequestHandler {
	/* Logger */
	private static final Log log = LogFactory.getLog(SynchroHttpHandler.class);

	private final File dataDirectory;

	private SimpleDateFormat dateFormatter;

	private Pattern datePattern;

	public SynchroHttpHandler(final File dataDirectory) {
		super();
		this.dataDirectory = dataDirectory;
		this.dateFormatter = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
		datePattern = Pattern.compile("20[0-9]{6}_[0-9]{6}_[0-9]{3}");
	}

	public void handle(
			final HttpRequest request,
			final HttpResponse response,
			final HttpContext context) throws HttpException, IOException {

		String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
		if (!method.equals("GET") && !method.equals("HEAD") && !method.equals("POST")) {
			throw new MethodNotSupportedException(method + " method not supported");
		}
		String target = request.getRequestLine().getUri();

		if (request instanceof HttpEntityEnclosingRequest) {
			HttpEntity entity = ((HttpEntityEnclosingRequest) request).getEntity();
			byte[] entityContent = EntityUtils.toByteArray(entity);
			log.debug("Incoming entity content (bytes): " + entityContent.length);
		}

		String path = URLDecoder.decode(target, "UTF-8");
		if ("/new".equals(path)) {
			doNew(request, response, context);
			return;
		}
		if (datePattern.matcher(path.substring(1)).matches()) {
			Date sysdate = null;
			try {
				sysdate = dateFormatter.parse(path.substring(1));
			} catch (ParseException e) {
				response.setStatusCode(HttpStatus.SC_NOT_FOUND);
				StringEntity entity = new StringEntity(
						"<html><body><h1>File " + path +
								" not found</h1></body></html>",
						ContentType.create("text/html", "UTF-8"));
				response.setEntity(entity);
				log.warn("Path " + path + " not found");
				return;
			}
			int percent = 50;
			String message = "Table XXX";
			StringEntity entity = new StringEntity(
					String.format("{percent: %s, message: %s}", percent, message),
					ContentType.create("text/html", "UTF-8"));
			response.setEntity(entity);
			return;
		}
		final File file = new File(this.dataDirectory, URLDecoder.decode(target, "UTF-8"));
		if (!file.exists()) {

			response.setStatusCode(HttpStatus.SC_NOT_FOUND);
			StringEntity entity = new StringEntity(
					"<html><body><h1>File" + file.getPath() +
							" not found</h1></body></html>",
					ContentType.create("text/html", "UTF-8"));
			response.setEntity(entity);
			log.warn("File " + file.getPath() + " not found");

		} else if (!file.canRead() || file.isDirectory()) {

			response.setStatusCode(HttpStatus.SC_FORBIDDEN);
			StringEntity entity = new StringEntity(
					"<html><body><h1>Access denied</h1></body></html>",
					ContentType.create("text/html", "UTF-8"));
			response.setEntity(entity);
			log.warn("Cannot read file " + file.getPath());

		} else {

			response.setStatusCode(HttpStatus.SC_OK);
			FileEntity body = new FileEntity(file, ContentType.create("text/html", (Charset) null));
			response.setEntity(body);
			log.debug("Serving file " + file.getPath());
		}
	}

	protected void doNew(final HttpRequest request,
			final HttpResponse response,
			final HttpContext context) {
		Date sysdate = new Date();
		String dateStr = dateFormatter.format(sysdate);
		StringEntity entity = new StringEntity(
				dateStr,
				ContentType.create("text/html", "UTF-8"));
		response.setEntity(entity);
	}

}