package fr.ifremer.adagio.synchro.intercept;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: ReferentialSynchroSpecificTableTask.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/synchro/specific/ReferentialSynchroSpecificTableTask.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Closeable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.hibernate.tool.hbm2ddl.TableMetadata;

import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroContext;

/**
 * Created on 4/10/14.
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.5.3
 */
public interface SynchroInterceptor extends Cloneable, Closeable {

	boolean apply(SynchroDatabaseMetadata meta, TableMetadata table);

	void setNext(SynchroInterceptor next);

	SynchroInterceptor getNext();

	SynchroInterceptor clone();

	void setContext(SynchroContext context);

	void onRead(Object[] data, SynchroTableDao dao) throws SQLException;

	void onWrite(Object[] data, String pkStr, SynchroTableDao dao, SynchroWriteBuffer buffer) throws SQLException;

	/**
	 * Given the extra rows of the local db, transform them to reinject them
	 * after in the current table.
	 * 
	 * @param dbMetas
	 * @param localDao
	 *            dao of the local db
	 * @param remoteDao
	 *            dao of the remote db
	 * @param extraRows
	 *            extra rows of the local db to transform
	 * @return transformed extra rows of the local db
	 */
	Map<List<Object>, Object[]> transformExtraLocalData(
			SynchroTableDao targetDao,
			SynchroTableDao sourceDao,
			Map<List<Object>, Object[]> extraRows) throws SQLException;

	void onTableLoad(SynchroTableMetadata table);

	void onJoinLoad(SynchroTableMetadata table, SynchroJoinMetadata join);

	String onCreateSelectQuery(SynchroTableMetadata table, String queryName, String selectQuery);

	boolean enableOnRead();

	boolean enableOnWrite();
}
