package fr.ifremer.adagio.synchro.socket;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.net.URL;
import java.security.KeyStore;

import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;

import fr.ifremer.adagio.synchro.config.SynchroConfiguration;

/**
 * HHTP server use for synchronization
 */
public class SynchroHttpServer {
	/* Logger */
	private static final Log log = LogFactory.getLog(SynchroHttpServer.class);

	public void start() throws Exception {
		SynchroConfiguration config = SynchroConfiguration.getInstance();

		int port = config.getServerPort();
		boolean useSsl = (port == 8443 || port == 443);
		File dataDirectory = config.getDataDirectory();

		// Create the directory if not exists
		if (!dataDirectory.exists() || !dataDirectory.isDirectory()) {
			log.error("Working directory not exists: " + dataDirectory);
			System.exit(0);
		}

		if (log.isInfoEnabled()) {
			log.info("Starting synchronization server...");
			log.info(" Port: " + port);
			if (useSsl) {
				log.info(" SSL: enable");
			}
		}

		// Set up the HTTP protocol processor
		HttpProcessor httpproc = HttpProcessorBuilder.create()
				.add(new ResponseDate())
				.add(new ResponseServer("Test/1.1"))
				.add(new ResponseContent())
				.add(new ResponseConnControl()).build();

		// Set up request handlers
		UriHttpRequestHandlerMapper reqistry = new UriHttpRequestHandlerMapper();
		SynchroHttpHandler baseHandler = new SynchroHttpHandler(dataDirectory);

		reqistry.register("*", baseHandler);

		// reqistry.register("**/*.html", new SynchroBrowserHandler(dataDirectory));

		// Set up the HTTP service
		HttpService httpService = new HttpService(httpproc, reqistry);

		SSLServerSocketFactory sf = null;
		if (useSsl) {
			// Initialize SSL context
			ClassLoader cl = SynchroHttpServer.class.getClassLoader();
			File sslKeyStoreFile = config.getServerSslKeyStore();
			URL url = cl.getResource(sslKeyStoreFile.getPath());
			if (url == null) {
				log.error("Keystore file not found: " + sslKeyStoreFile.getPath());
				System.exit(1);
			}
			KeyStore keystore = KeyStore.getInstance("jks");
			keystore.load(url.openStream(), "secret".toCharArray());
			KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(
					KeyManagerFactory.getDefaultAlgorithm());
			kmfactory.init(keystore, "secret".toCharArray());
			KeyManager[] keymanagers = kmfactory.getKeyManagers();
			SSLContext sslcontext = SSLContext.getInstance("TLS");
			sslcontext.init(keymanagers, null, null);
			sf = sslcontext.getServerSocketFactory();
		}

		Thread t = new SynchroRequestListenerThread(port, httpService, sf);
		t.setDaemon(false);
		t.start();
	}

}