package fr.ifremer.adagio.synchro.service;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections4.MapUtils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import fr.ifremer.adagio.synchro.intercept.SynchroWriteBuffer;

public class SynchroTableOperationBuffer implements SynchroWriteBuffer {

	private Map<String, Map<String, Object>> missingUpdates = Maps.newHashMap();

	private Map<String, Map<String, List<Object>>> childTablesToUpdate = Maps.newHashMap();

	private Map<String, Map<Set<String>, List<List<Object>>>> childTablesToUpdateComplexMap = Maps.newHashMap();

	private final String tableName;

	public SynchroTableOperationBuffer(String tableName) {
		this.tableName = tableName;
	}

	public String getTableName() {
		return tableName;
	}

	public Map<String, Map<String, Object>> getMissingUpdates() {
		return missingUpdates;
	}

	@Override
	public void addMissingColumnUpdate(String columnName, String pkStr, Object columnValue) {
		Map<String, Object> destRows = missingUpdates.get(columnName);
		if (destRows == null) {
			destRows = Maps.newHashMap();
			missingUpdates.put(columnName, destRows);
		}
		destRows.put(pkStr, columnValue);
	}

	public void addChildToUpdate(String childTablename, Set<String> columnNames, List<Object> columnValues) {
		Map<Set<String>, List<List<Object>>> childTable = childTablesToUpdateComplexMap.get(childTablename);
		if (childTable == null) {
			childTable = Maps.newHashMap();
			childTablesToUpdateComplexMap.put(childTablename, childTable);
		}
		List<List<Object>> childColumnValues = childTable.get(columnNames);
		if (childColumnValues == null) {
			childColumnValues = Lists.newArrayList();
			childTable.put(columnNames, childColumnValues);
		}
		childColumnValues.add(columnValues);
	}

	public Map<String, Map<Set<String>, List<List<Object>>>> getChildToUpdateComplexMap() {
		return childTablesToUpdateComplexMap;
	}

	public void addChildToUpdate(String childTablename, String columnName, Object columnValue) {
		Map<String, List<Object>> childTable = childTablesToUpdate.get(childTablename);
		if (childTable == null) {
			childTable = Maps.newHashMap();
			childTablesToUpdate.put(childTablename, childTable);
		}
		List<Object> childColumnValues = childTable.get(columnName);
		if (childColumnValues == null) {
			childColumnValues = Lists.newArrayList();
			childTable.put(columnName, childColumnValues);
		}
		childColumnValues.add(columnValue);
	}

	public void addChildsToUpdate(String childTablename, String columnName, List<Object> columnValues) {
		Map<String, List<Object>> childTable = childTablesToUpdate.get(childTablename);
		if (childTable == null) {
			childTable = Maps.newHashMap();
			childTablesToUpdate.put(childTablename, childTable);
		}
		List<Object> childColumnValues = childTable.get(columnName);
		if (childColumnValues == null) {
			childColumnValues = Lists.newArrayList();
			childTable.put(columnName, columnValues);
		}
		childColumnValues.addAll(columnValues);
	}

	public Map<String, Map<String, List<Object>>> getChildToUpdate() {

		return childTablesToUpdate;
	}

	public boolean isEmpty() {
		return MapUtils.isEmpty(missingUpdates) && MapUtils.isEmpty(childTablesToUpdate) && MapUtils.isEmpty(childTablesToUpdateComplexMap);
	}

}
