package fr.ifremer.adagio.synchro.config;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: TuttiConfigurationOption.java 1441 2013-12-09 20:13:47Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/tutti/TuttiConfigurationOption.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import static org.nuiton.i18n.I18n.n;

import java.io.File;
import java.net.URL;
import java.util.Locale;

import org.hibernate.dialect.HSQLDialect;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.util.Version;

/**
 * All application configuration options.
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.5.3
 */
public enum SynchroConfigurationOption implements ConfigOptionDef {

	// ------------------------------------------------------------------------//
	// -- READ-ONLY OPTIONS ---------------------------------------------------//
	// ------------------------------------------------------------------------//

	BASEDIR(
			"adagio.basedir",
			n("adagio.config.option.basedir.description"),
			"${user.home}/.adagio",
			File.class),

	DATA_DIRECTORY(
			"adagio.data.directory",
			n("adagio.config.option.data.directory.description"),
			"${adagio.basedir}/data",
			File.class),

	I18N_DIRECTORY(
			"adagio.i18n.directory",
			n("adagio.config.option.i18n.directory.description"),
			"${adagio.basedir}/i18n",
			File.class),

	TMP_DIRECTORY(
			"adagio.tmp.directory",
			n("adagio.config.option.tmp.directory.description"),
			"${adagio.data.directory}/temp",
			File.class),

	DB_DIRECTORY(
			"adagio.persistence.db.directory",
			n("adagio.config.option.persistence.db.directory.description"),
			"${adagio.data.directory}/db",
			File.class),

	DB_ATTACHMENT_DIRECTORY(
			"adagio.persistence.db.attachment.directory",
			n("adagio.config.option.persistence.db.attachment.directory.description"),
			"${adagio.data.directory}/meas_files",
			File.class),

	DB_CACHE_DIRECTORY(
			"adagio.persistence.db.cache.directory",
			n("adagio.config.option.persistence.db.cache.directory.description"),
			"${adagio.data.directory}/dbcache",
			File.class),

	DB_NAME(
			"adagio.persistence.db.name",
			n("adagio.config.option.persistence.db.name.description"),
			"allegro",
			String.class),

	DB_HOST(
			"adagio.persistence.db.host",
			n("adagio.config.option.persistence.db.host.description"),
			"",
			String.class),

	DB_PORT(
			"adagio.persistence.db.port",
			n("adagio.config.option.persistence.db.port.description"),
			"",
			String.class),

	DB_VALIDATION_QUERY(
			"adagio.persistence.db.validation-query",
			n("adagio.persistence.db.validation-query.description"),
			"SELECT COUNT(*) FROM STATUS",
			String.class),

	JDBC_USERNAME(
			"adagio.persistence.jdbc.username",
			n("adagio.config.option.persistence.jdbc.username.description"),
			"sa",
			String.class),

	JDBC_PASSWORD(
			"adagio.persistence.jdbc.password",
			n("adagio.config.option.persistence.jdbc.password.description"),
			"",
			String.class),

	JDBC_URL(
			"adagio.persistence.jdbc.url",
			n("adagio.config.option.persistence.jdbc.url.description"),
			"jdbc:hsqldb:file:${adagio.persistence.db.directory}/${adagio.persistence.db.name}",
			String.class),

	JDBC_DRIVER(
			"adagio.persistence.jdbc.driver",
			n("adagio.config.option.persistence.jdbc.driver.description"),
			"org.hsqldb.jdbcDriver",
			Class.class),

	HIBERNATE_DIALECT(
			"adagio.persistence.hibernate.dialect",
			n("adagio.config.option.persistence.hibernate.dialect.description"),
			HSQLDialect.class.getName(),
			Class.class),

	VERSION(
			"adagio.persistence.version",
			n("adagio.config.option.persistence.version.description"),
			"3.4.2",
			Version.class),

	SITE_URL(
			"adagio.site.url",
			n("adagio.config.option.site.url.description"),
			"http://www.ifremer.fr/sih-adagio",
			URL.class),

	ORGANIZATION_NAME(
			"adagio.organizationName",
			n("adagio.config.option.organizationName.description"),
			"Ifremer",
			String.class),

	INCEPTION_YEAR(
			"adagio.inceptionYear",
			n("adagio.config.option.inceptionYear.description"),
			"2011",
			Integer.class),

	SYNCHRONIZATION_STATUS_SYNCHRONIZED(
			"adagio.synchro.enumeration.SynchronizationStatus.SYNCHRONIZED",
			n("adagio.synchro.enumeration.SynchronizationStatus.SYNCHRONIZED.description"),
			"SYNC",
			String.class),

	SYNCHRONIZATION_STATUS_READY_TO_SYNCHRONIZE(
			"adagio.synchro.enumeration.SynchronizationStatus.READY_TO_SYNCHRONIZE",
			n("adagio.synchro.enumeration.SynchronizationStatus.READY_TO_SYNCHRONIZE.description"),
			"READY_TO_SYNC",
			String.class),

	SYNCHRONIZATION_STATUS_DELETED(
			"adagio.synchro.enumeration.SynchronizationStatus.DELETED",
			n("adagio.synchro.enumeration.SynchronizationStatus.DELETED.description"),
			"DELETED",
			String.class),

	SYNCHRONIZATION_STATUS_DIRTY(
			"adagio.synchro.enumeration.SynchronizationStatus.DIRTY",
			n("adagio.synchro.enumeration.SynchronizationStatus.DIRTY.description"),
			"DIRTY",
			String.class),

	// ------------------------------------------------------------------------//
	// -- DB use for IMPORT (READ-ONLY) OPTIONS ----------------------------------//
	// ------------------------------------------------------------------------//

	IMPORT_DB_DIRECTORY(
			"adagio.synchro.import.db.directory",
			n("adagio.config.option.synchro.import.db.directory.description"),
			"${adagio.data.directory}/dbimport",
			File.class),

	IMPORT_DB_ATTACHMENT_DIRECTORY(
			"adagio.synchro.import.db.attachment.directory",
			n("adagio.config.option.synchro.import.db.attachment.directory.description"),
			"${adagio.synchro.import.db.directory}/meas_files",
			File.class),

	IMPORT_DB_NAME(
			"adagio.synchro.import.db.name",
			n("adagio.config.option.synchro.import.db.name.description"),
			"allegro",
			String.class),

	IMPORT_DB_HOST(
			"adagio.synchro.import.db.host",
			n("adagio.config.option.synchro.import.db.host.description"),
			"",
			String.class),

	IMPORT_DB_PORT(
			"adagio.synchro.import.db.port",
			n("adagio.config.option.synchro.import.db.port.description"),
			"",
			String.class),

	IMPORT_JDBC_USERNAME(
			"adagio.synchro.import.jdbc.username",
			n("adagio.config.option.synchro.import.jdbc.username.description"),
			"sa",
			String.class),

	IMPORT_JDBC_PASSWORD(
			"adagio.synchro.import.jdbc.password",
			n("adagio.config.option.synchro.import.jdbc.password.description"),
			"",
			String.class),

	IMPORT_JDBC_SCHEMA(
			"adagio.synchro.import.jdbc.schema",
			n("adagio.config.option.synchro.import.jdbc.schema.description"),
			null,
			String.class),

	IMPORT_JDBC_CATALOG(
			"adagio.synchro.import.jdbc.catalog",
			n("adagio.config.option.synchro.import.jdbc.catalog.description"),
			null,
			String.class),

	IMPORT_JDBC_URL(
			"adagio.synchro.import.jdbc.url",
			n("adagio.config.option.synchro.import.jdbc.url.description"),
			"jdbc:hsqldb:file:${adagio.synchro.import.db.directory}/${adagio.synchro.import.db.name}",
			String.class),

	IMPORT_JDBC_DRIVER(
			"adagio.synchro.import.jdbc.driver",
			n("adagio.config.option.synchro.import.jdbc.driver.description"),
			"org.hsqldb.jdbcDriver",
			Class.class),

	IMPORT_HIBERNATE_DIALECT(
			"adagio.synchro.import.hibernate.dialect",
			n("adagio.config.option.synchro.import.hibernate.dialect.description"),
			HSQLDialect.class.getName(),
			Class.class),

	IMPORT_TABLES_DATA_INCLUDES(
			"adagio.synchro.import.tables.data.includes",
			n("adagio.config.option.synchro.import.tables.data.includes.description"),
			"",
			String.class),

	IMPORT_TABLES_REFERENTIAL_INCLUDES(
			"adagio.synchro.import.tables.referential.includes",
			n("adagio.config.option.synchro.import.tables.referential.includes.description"),
			"",
			String.class),

	IMPORT_JDBC_BATCH_SIZE(
			"adagio.synchro.import.jdbc.batch-size",
			n("adagio.config.option.synchro.import.jdbc.batch-size.description"),
			"1000",
			Integer.class),

	// ------------------------------------------------------------------------//
	// -- Client/Server (READ-ONLY) OPTIONS ----------------------------------//
	// ------------------------------------------------------------------------//

	SERVER_PORT(
			"adagio.server.port",
			n("adagio.config.option.server.port.description"),
			"8080",
			Integer.class,
			false),

	SERVER_SSL_KEYSTORE(
			"adagio.server.ssl.keystore.file",
			n("adagio.config.option.server.ssl.keystore.file.description"),
			"my.keystore",
			File.class,
			false),

	// ------------------------------------------------------------------------//
	// -- READ-WRITE OPTIONS --------------------------------------------------//
	// ------------------------------------------------------------------------//

	DB_BACKUP_DIRECTORY(
			"adagio.persistence.db.backup.directory",
			n("adagio.config.option.persistence.db.backup.directory.description"),
			"${adagio.data.directory}/dbbackup",
			File.class,
			false),

	I18N_LOCALE(
			"adagio.i18n.locale",
			n("adagio.config.option.i18n.locale.description"),
			Locale.FRANCE.getCountry(),
			Locale.class,
			false
	);

	/** Configuration key. */
	private final String key;

	/** I18n key of option description */
	private final String description;

	/** Type of option */
	private final Class<?> type;

	/** Default value of option. */
	private String defaultValue;

	/** Flag to not keep option value on disk */
	private boolean isTransient;

	/** Flag to not allow option value modification */
	private boolean isFinal;

	SynchroConfigurationOption(String key,
			String description,
			String defaultValue,
			Class<?> type,
			boolean isTransient) {
		this.key = key;
		this.description = description;
		this.defaultValue = defaultValue;
		this.type = type;
		this.isTransient = isTransient;
		this.isFinal = isTransient;
	}

	SynchroConfigurationOption(String key,
			String description,
			String defaultValue,
			Class<?> type) {
		this(key, description, defaultValue, type, true);
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public Class<?> getType() {
		return type;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public String getDefaultValue() {
		return defaultValue;
	}

	@Override
	public boolean isTransient() {
		return isTransient;
	}

	@Override
	public boolean isFinal() {
		return isFinal;
	}

	@Override
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	@Override
	public void setTransient(boolean newValue) {
		// not used
	}

	@Override
	public void setFinal(boolean newValue) {
		// not used
	}
}
