package fr.ifremer.adagio.synchro.action;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Version;

import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoUtils;

public class SynchroImportDataAction {
	/* Logger */
	private static final Log log = LogFactory.getLog(SynchroImportDataAction.class);

	public void run() {
		if (log.isInfoEnabled()) {
			log.info("Starting database importation...");
			log.info(String.format(" Database directory: %s", SynchroConfiguration.getInstance().getDbDirectory()));
			log.info(String.format(" JDBC Driver: %s", SynchroConfiguration.getInstance().getJdbcDriver()));
			log.info(String.format(" JDBC URL: %s", SynchroConfiguration.getInstance().getJdbcURL()));
			log.info(String.format(" JDBC Username: %s", SynchroConfiguration.getInstance().getJdbcUsername()));
		}

		boolean isValidConnection = DaoUtils.isValidConnectionProperties(SynchroConfiguration.getInstance().getJdbcDriver(),
				SynchroConfiguration.getInstance().getJdbcURL(),
				SynchroConfiguration.getInstance().getJdbcUsername(),
				SynchroConfiguration.getInstance().getJdbcPassword());

		if (!isValidConnection) {
			log.warn("Connection error : could not check database status.");
			return;
		}

		// TODO : run the data synchro
	}

}
