package fr.ifremer.adagio.core.service.referential.location.impl;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import fr.ifremer.adagio.core.dao.referential.location.LocationLevelId;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.service.referential.location.LocationService;

@Service("locationService")
public class LocationServiceImpl implements LocationService {

	@Resource(name = "locationDao")
	private LocationExtendDao locationDao;

	@Value("${LocationLevelId.RECTANGLE_STATISTIQUE_MED}")
	private final Integer RECTANGLE_STATISTIQUE_MED = new Integer(-1);

	@Override
	public String getLocationLabelByLatLong(Float latitude, Float longitude) {
		if (longitude == null || latitude == null) {
			throw new IllegalArgumentException("Arguments 'latitude' and 'longitude' should not be null.");
		}
		return locationDao.getLocationLabelByLatLong(latitude, longitude);
	}

	@Override
	public Integer getLocationIdByLatLong(Float latitude, Float longitude) {
		String locationLabel = getLocationLabelByLatLong(latitude, longitude);
		if (locationLabel == null) {
			return null;
		}
		Integer locationId = locationDao.getLocationIdByLabelAndLocationLevel(locationLabel,
				new Integer[] {LocationLevelId.RECTANGLE_STATISTIQUE.getValue(), RECTANGLE_STATISTIQUE_MED,
				LocationLevelId.FAO_ZONE.getValue() });
		return locationId;
	}
	
	
}
